/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.config;

import static java.util.Arrays.asList;

import java.util.Collection;

import org.mule.runtime.dsl.api.xml.XmlNamespaceInfo;
import org.mule.runtime.dsl.api.xml.XmlNamespaceInfoProvider;

/**
 * <p>
 * Provides the MUnit Namespace Information
 * </p>
 *
 * @since 2.0.0
 * @author Mulesoft Inc.
 */
public class MunitXmlNamespaceInfoProvider implements XmlNamespaceInfoProvider {

  public static final String NAME_SPACE = "munit";

  @Override
  public Collection<XmlNamespaceInfo> getXmlNamespacesInfo() {
    return asList(new XmlNamespaceInfo() {

      @Override
      public String getNamespaceUriPrefix() {
        return "http://www.mulesoft.org/schema/mule/munit";
      }

      @Override
      public String getNamespace() {
        return NAME_SPACE;
      }
    });
  }
}
