/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.component.state;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.mule.munit.runner.processors.MunitModule;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.deployment.management.ComponentInitialStateManager;

public class MunitComponentInitialStateManager
implements ComponentInitialStateManager {
    private static final Boolean DEFAULT_MESSAGESOURCE_STATE = false;
    protected static final String MUNIT_DISABLE_INITIAL_STATE_MANAGER = "munit.disable.initial.state.manager";
    protected static final String MUNIT_ENABLE_SOURCES_ON_START = "munit.enable.sources.on.start";
    @Inject
    protected Registry registry;

    public boolean mustStartMessageSource(Component component) {
        if (component == null) {
            return false;
        }
        if (this.disableInitialStateManager().booleanValue()) {
            return true;
        }
        if (!this.getMunitModule().isPresent()) {
            return DEFAULT_MESSAGESOURCE_STATE;
        }
        if (this.enableSourcesOnStartActivated().booleanValue()) {
            return this.enableSourceOnStart(component);
        }
        return false;
    }

    private boolean enableSourceOnStart(Component component) {
        if (this.getMunitModule().get().getEnableFlowSources().getFlows().isEmpty()) {
            return !this.getMunitModule().get().isDisableFlowSources();
        }
        return this.shouldStartMessageSource(component);
    }

    private boolean shouldStartMessageSource(Component component) {
        Boolean shouldStart = !this.getMunitModule().get().isDisableFlowSources();
        List flowNameList = this.getMunitModule().get().getEnableFlowSources().getFlows().stream().map(f -> f.getFlow().getRootContainerLocation().getGlobalName()).collect(Collectors.toList());
        if (flowNameList.contains(component.getLocation().getRootContainerName())) {
            return shouldStart == false;
        }
        return shouldStart;
    }

    private Optional<MunitModule> getMunitModule() {
        return this.registry.lookupByType(MunitModule.class);
    }

    private Boolean disableInitialStateManager() {
        return Boolean.valueOf(System.getProperty(MUNIT_DISABLE_INITIAL_STATE_MANAGER, "false"));
    }

    private Boolean enableSourcesOnStartActivated() {
        return Boolean.valueOf(System.getProperty(MUNIT_ENABLE_SOURCES_ON_START, "false"));
    }
}

