/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.processors;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.activation.DataHandler;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.mule.munit.common.event.EventBuilder;
import org.mule.munit.common.exception.MunitError;
import org.mule.munit.common.model.Attachment;
import org.mule.munit.common.model.Event;
import org.mule.munit.common.model.EventAttributes;
import org.mule.munit.common.model.EventError;
import org.mule.munit.common.model.NullObject;
import org.mule.munit.common.model.Payload;
import org.mule.munit.common.model.Property;
import org.mule.munit.common.model.UntypedEventError;
import org.mule.munit.common.model.Variable;
import org.mule.munit.common.util.IOUtils;
import org.mule.munit.runner.processors.MunitProcessor;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.DataTypeBuilder;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.privileged.PrivilegedMuleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetEventProcessor
extends MunitProcessor {
    private static final String MEDIA_TYPE_FIELD = "Media Type";
    private static final String ENCODING_FIELD = "Encoding";
    private static final String KEY_FIELD = "Key";
    private transient Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Boolean cloneOriginalEvent = false;
    private Event event = new Event();
    @Inject
    PrivilegedMuleContext muleContext;

    @Override
    protected String getProcessor() {
        return "set";
    }

    @Override
    protected CoreEvent doProcess(CoreEvent incomingEvent) {
        EventBuilder builder = this.cloneOriginalEvent != false ? new EventBuilder((org.mule.runtime.api.event.Event)incomingEvent) : new EventBuilder(incomingEvent.getContext());
        this.evaluatePayload(this.event.getPayload(), incomingEvent, builder);
        this.evaluateMediaType(this.event.getPayload(), incomingEvent, builder);
        this.evaluateAttributes(this.event.getAttributes(), incomingEvent, builder);
        this.evaluateErrorType(this.event.getError(), incomingEvent, builder);
        this.evaluateVariables(this.event.getVariables(), incomingEvent, builder);
        this.evaluatePropertiesAndAttachments(this.event, incomingEvent, builder);
        return (CoreEvent)builder.build();
    }

    private void evaluatePropertiesAndAttachments(Event returnEvent, CoreEvent incomingEvent, EventBuilder builder) {
        this.evaluateProperties(returnEvent.getSessionProperties(), returnEvent.getInboundProperties(), returnEvent.getOutboundProperties(), incomingEvent, builder);
        this.evaluateAttachments(returnEvent.getInboundAttachments(), returnEvent.getOutboundAttachments(), incomingEvent, builder);
        this.logWarningIfPropertiesOrAttachmentsPresent(returnEvent.getInboundAttachments(), returnEvent.getOutboundAttachments(), returnEvent.getSessionProperties(), returnEvent.getInboundProperties(), returnEvent.getOutboundProperties());
    }

    private void evaluateAttachments(List<Attachment> inboundAttachments, List<Attachment> outboundAttachments, CoreEvent incomingEvent, EventBuilder builder) {
        if (null != inboundAttachments) {
            if (inboundAttachments.isEmpty()) {
                builder.withInboundAttachments(Collections.emptyMap());
            } else {
                inboundAttachments.forEach(a -> builder.addInboundAttachment(this.evaluateAsString(incomingEvent, a.getKey(), KEY_FIELD), this.getDataHandler(incomingEvent, (Attachment)a)));
            }
        }
        if (null != outboundAttachments) {
            if (outboundAttachments.isEmpty()) {
                builder.withOutboundAttachments(Collections.emptyMap());
            } else {
                outboundAttachments.forEach(a -> builder.addOutboundAttachment(this.evaluateAsString(incomingEvent, a.getKey(), KEY_FIELD), this.getDataHandler(incomingEvent, (Attachment)a)));
            }
        }
    }

    private void evaluateProperties(List<Property> sessionProperties, List<Property> inboundProperties, List<Property> outboundProperties, CoreEvent incomingEvent, EventBuilder builder) {
        if (null != sessionProperties) {
            if (sessionProperties.isEmpty()) {
                builder.clearSessionProperties();
            } else {
                sessionProperties.forEach(p -> builder.addSessionProperty(this.evaluateAsString(incomingEvent, p.getKey(), KEY_FIELD), this.evaluate(incomingEvent, p.getValue()), this.evaluateMediaTypeExpression(incomingEvent, p.getMediaType()), this.evaluateAsString(incomingEvent, p.getEncoding(), ENCODING_FIELD)));
            }
        }
        if (null != inboundProperties) {
            if (inboundProperties.isEmpty()) {
                builder.withInboundProperties(Collections.emptyMap());
            } else {
                inboundProperties.forEach(p -> builder.addInboundProperty(this.evaluateAsString(incomingEvent, p.getKey(), KEY_FIELD), (Serializable)this.evaluate(incomingEvent, p.getValue()), this.evaluateMediaTypeExpression(incomingEvent, p.getMediaType()), this.evaluateAsString(incomingEvent, p.getEncoding(), ENCODING_FIELD)));
            }
        }
        if (null != outboundProperties) {
            if (outboundProperties.isEmpty()) {
                builder.withOutboundProperties(Collections.emptyMap());
            } else {
                outboundProperties.forEach(p -> builder.addOutboundProperty(this.evaluateAsString(incomingEvent, p.getKey(), KEY_FIELD), (Serializable)this.evaluate(incomingEvent, p.getValue()), this.evaluateMediaTypeExpression(incomingEvent, p.getMediaType()), this.evaluateAsString(incomingEvent, p.getEncoding(), ENCODING_FIELD)));
            }
        }
    }

    private void evaluateVariables(List<Variable> variables, CoreEvent incomingEvent, EventBuilder builder) {
        if (null != variables) {
            if (variables.isEmpty()) {
                builder.withVariables(Collections.emptyMap());
            } else {
                variables.forEach(v -> builder.addVariable(this.evaluateAsString(incomingEvent, v.getKey(), KEY_FIELD), this.evaluate(incomingEvent, v.getValue()), this.evaluateMediaTypeExpression(incomingEvent, v.getMediaType()), this.evaluateAsString(incomingEvent, v.getEncoding(), ENCODING_FIELD)));
            }
        }
    }

    private void evaluatePayload(Payload payload, CoreEvent incomingEvent, EventBuilder builder) {
        if (!(payload.getValue() instanceof NullObject)) {
            builder.withPayload(this.evaluate(incomingEvent, payload.getValue()));
        }
    }

    private void evaluateMediaType(Payload payload, CoreEvent incomingEvent, EventBuilder builder) {
        DataTypeBuilder dataTypeBuilder = DataType.builder();
        MediaType mediaType = null;
        if (this.cloneOriginalEvent.booleanValue() && StringUtils.isNotBlank((CharSequence)payload.getMediaType())) {
            dataTypeBuilder.mediaType(this.evaluateMediaTypeExpression(incomingEvent, payload.getMediaType()));
        }
        if (!this.cloneOriginalEvent.booleanValue()) {
            dataTypeBuilder.mediaType(this.evaluateMediaTypeExpression(incomingEvent, payload.getMediaType()));
        }
        if (StringUtils.isNotBlank((CharSequence)payload.getEncoding())) {
            dataTypeBuilder.charset(this.evaluateAsString(incomingEvent, payload.getEncoding(), ENCODING_FIELD));
        }
        if (this.cloneOriginalEvent.booleanValue() && StringUtils.isNotBlank((CharSequence)payload.getMediaType()) || !this.cloneOriginalEvent.booleanValue() || StringUtils.isNotBlank((CharSequence)payload.getEncoding())) {
            mediaType = dataTypeBuilder.build().getMediaType();
        }
        if (mediaType != null) {
            builder.withMediaType(mediaType);
        }
    }

    private void evaluateAttributes(EventAttributes attributes, CoreEvent incomingEvent, EventBuilder builder) {
        try {
            if (attributes.getValue() != null && !(attributes.getValue() instanceof NullObject)) {
                builder.withAttributes(this.evaluate(incomingEvent, attributes.getValue()), this.evaluateMediaTypeExpression(incomingEvent, attributes.getMediaType()), this.evaluateAsString(incomingEvent, attributes.getEncoding(), ENCODING_FIELD));
            }
        }
        catch (ClassCastException e) {
            throw new MunitError("Attributes evaluation failed", (Throwable)e);
        }
    }

    private void evaluateErrorType(EventError error, CoreEvent incomingEvent, EventBuilder builder) {
        ErrorType errorType = null;
        String errorTypeId = this.evaluateAsString(incomingEvent, error.getTypeId(), "Error Type Id");
        if (StringUtils.isNotBlank((CharSequence)errorTypeId) && null != this.evaluate(incomingEvent, error.getCause())) {
            ComponentIdentifier componentIdentifier = ComponentIdentifier.buildFromStringRepresentation((String)errorTypeId);
            errorType = this.muleContext.getErrorTypeLocator().lookupComponentErrorType(componentIdentifier, this.evaluateErrorCause(error, incomingEvent));
        }
        if (null != errorType) {
            builder.withError(errorType, this.evaluateErrorCause(error, incomingEvent));
        }
    }

    private Throwable evaluateErrorCause(EventError error, CoreEvent incomingEvent) {
        try {
            return (Throwable)this.evaluate(incomingEvent, error.getCause());
        }
        catch (ClassCastException e) {
            throw new MunitError(String.format("Error cause '%s' should be Throwable", error.getCause()), (Throwable)e);
        }
    }

    private String evaluateAsString(CoreEvent event, Object expression, String name) {
        return this.expressionWrapper.evaluateAsStringIfExpression((org.mule.runtime.api.event.Event)event, expression, name);
    }

    protected Object evaluate(CoreEvent event, Object possibleExpression) {
        return this.expressionWrapper.evaluateIfExpression((org.mule.runtime.api.event.Event)event, possibleExpression).getValue();
    }

    private String evaluateMediaTypeExpression(CoreEvent event, Object mediaTypeExpression) {
        if (mediaTypeExpression == null) {
            return MediaType.ANY.toString();
        }
        return this.expressionWrapper.evaluateNotNullString((org.mule.runtime.api.event.Event)event, mediaTypeExpression, MEDIA_TYPE_FIELD);
    }

    private DataHandler getDataHandler(CoreEvent event, Attachment attachment) {
        MediaType contentType = DataType.builder().mediaType(this.evaluateMediaTypeExpression(event, attachment.getMediaType())).charset(this.expressionWrapper.evaluateAsStringIfExpression((org.mule.runtime.api.event.Event)event, (Object)attachment.getEncoding(), ENCODING_FIELD)).build().getMediaType();
        try {
            return IOUtils.toDataHandler((String)attachment.getKey(), (Object)this.expressionWrapper.evaluateIfExpression((org.mule.runtime.api.event.Event)event, (Object)attachment.getValue()).getValue(), (MediaType)contentType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setCloneOriginalEvent(Boolean cloneOriginalEvent) {
        this.cloneOriginalEvent = cloneOriginalEvent;
    }

    public void setPayload(Payload payload) {
        this.event.setPayload(payload);
    }

    public void setAttributes(EventAttributes attributes) {
        this.event.setAttributes(attributes);
    }

    public void setVariables(List<Variable> variables) {
        Validate.notNull(variables, (String)"Variables can not be null", (Object[])new Object[0]);
        this.event.setVariables(variables);
    }

    public void setSessionProperties(List<Property> sessionProperties) {
        Validate.notNull(sessionProperties, (String)"Session properties can not be null", (Object[])new Object[0]);
        this.event.setSessionProperties(sessionProperties);
    }

    public void setInboundProperties(List<Property> inboundProperties) {
        Validate.notNull(inboundProperties, (String)"Inbound properties can not be null", (Object[])new Object[0]);
        this.event.setInboundProperties(inboundProperties);
    }

    public void setOutboundProperties(List<Property> outboundProperties) {
        Validate.notNull(outboundProperties, (String)"Outbound properties can not be null", (Object[])new Object[0]);
        this.event.setOutboundProperties(outboundProperties);
    }

    public void setInboundAttachments(List<Attachment> inboundAttachments) {
        Validate.notNull(inboundAttachments, (String)"Inbound attachments can not be null", (Object[])new Object[0]);
        this.event.setInboundAttachments(inboundAttachments);
    }

    public void setOutboundAttachments(List<Attachment> outboundAttachments) {
        Validate.notNull(outboundAttachments, (String)"outbound attachments can not be null", (Object[])new Object[0]);
        this.event.setOutboundAttachments(outboundAttachments);
    }

    public void setError(UntypedEventError error) {
        this.event.setError((EventError)error);
    }

    protected void setMuleContext(PrivilegedMuleContext muleContext) {
        this.muleContext = muleContext;
    }

    private void logWarningIfPropertiesOrAttachmentsPresent(List<Attachment> inboundAttachments, List<Attachment> outboundAttachments, List<Property> sessionProperties, List<Property> inboundProperties, List<Property> outboundProperties) {
        boolean hasProperties;
        boolean hasAttachments = inboundAttachments != null || outboundAttachments != null;
        boolean bl = hasProperties = inboundProperties != null || outboundProperties != null || sessionProperties != null;
        if (hasAttachments || hasProperties) {
            if (this.logger.isDebugEnabled()) {
                this.logger.warn("Setting properties/attachments will only work in Mule 4 if the compatibility module is present. If not, they will have no effect since they are meant for Mule versions 3.x");
            } else {
                this.logger.warn("Setting elements that only work for Mule versions 3.x ");
            }
        }
    }
}

