/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.remote.api.notifiers;

import java.io.PrintStream;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.common.protocol.listeners.RunEventListener;
import org.mule.munit.common.protocol.message.TestStatus;

public class StreamNotifier
implements RunEventListener {
    private static final String SUITE_TOKEN = "=";
    private static final String TEST_TOKEN = "+";
    private PrintStream out;
    private int tests = 0;
    private int failures = 0;
    private int errors = 0;
    private int skipped = 0;

    public StreamNotifier(PrintStream out) {
        this.out = out;
    }

    public void notifyTestStart(String name, String description) {
        String descriptionMessage = StringUtils.isBlank((CharSequence)description) ? "" : " - " + description;
        String testMessage = "+ Running test: " + name + descriptionMessage + StringUtils.repeat((String)" ", (int)10) + TEST_TOKEN;
        String title = StringUtils.repeat((String)TEST_TOKEN, (int)testMessage.length());
        this.out.println(title);
        this.out.println(testMessage);
        this.out.println(title);
        this.out.flush();
    }

    public void notifySuiteStart(String suite, int numberOfTests) {
        String suiteMessage = StringUtils.repeat((String)SUITE_TOKEN, (int)12) + "  Running  " + suite + " suite " + StringUtils.repeat((String)SUITE_TOKEN, (int)12);
        String title = StringUtils.repeat((String)SUITE_TOKEN, (int)suiteMessage.length());
        this.out.println(title);
        this.out.println(suiteMessage);
        this.out.println(title);
        this.out.flush();
    }

    public void notifyTestEnd(String name, String stackTrace, TestStatus status, long elapsedTime) {
        ++this.tests;
        String message = "";
        switch (status) {
            case SUCCESS: {
                message = "SUCCESS - Test " + name + " finished successfully";
                break;
            }
            case ERROR: {
                message = "ERROR - The test " + name + " finished with an error";
                ++this.errors;
                break;
            }
            case FAILURE: {
                message = "FAILURE - The test " + name + " finished with a failure";
                ++this.failures;
                break;
            }
            case IGNORED: {
                message = "SKIPPED - Test " + name + " was Skipped";
                ++this.skipped;
            }
        }
        message = "+ " + message + " - Time elapsed: " + elapsedTime + "ms " + TEST_TOKEN;
        this.out.println(StringUtils.repeat((String)TEST_TOKEN, (int)message.length()));
        this.out.println(message);
        if (StringUtils.isNotBlank((CharSequence)stackTrace)) {
            this.out.println(stackTrace);
        }
        this.out.println(StringUtils.repeat((String)TEST_TOKEN, (int)message.length()));
        this.out.flush();
    }

    public void notifySuiteEnd(String suite, long elapsedTime) {
        this.out.println();
        String title = "Number of tests run: " + this.tests + " - Failed: " + this.failures + " - Errors: " + this.errors + " - Skipped: " + this.skipped + " - Time elapsed: " + elapsedTime + "ms";
        String titleFrame = StringUtils.repeat((String)SUITE_TOKEN, (int)title.length());
        this.out.println(titleFrame);
        this.out.println(title);
        this.out.println(titleFrame);
        this.out.flush();
    }
}

