/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.domain;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MuleDeployPropertyLoader {
    public static final String DEFAULT_MULE_DEPLOY_PROPERTIES_RESOURCE = "mule-deploy.properties";
    private static final String MULE_DEPLOY_PROPERTIES_RELATIVE_PATH = File.separator + "target" + File.separator + "classes" + File.separator + "mule-deploy.properties";
    private static final String MULE_DEPLOY_PROPERTIES_TEST_RELATIVE_PATH = File.separator + "target" + File.separator + "test-classes" + File.separator + "mule-deploy.properties";
    private transient Log log = LogFactory.getLog(this.getClass());
    private final String projectName;
    private Map<String, String> domainDeployPropertiesMap = null;
    private Map<String, String> applicationDeployPropertiesMap = null;

    public MuleDeployPropertyLoader(String projectName) {
        this.projectName = projectName;
    }

    public Map<String, String> getApplicationDeployProperties() {
        if (null == this.applicationDeployPropertiesMap) {
            this.loadApplicationDeployProperties();
        }
        return this.applicationDeployPropertiesMap;
    }

    public Map<String, String> getDomainDeployProperties() {
        if (null == this.applicationDeployPropertiesMap) {
            this.loadApplicationDeployProperties();
        }
        if (null == this.domainDeployPropertiesMap) {
            String domainName = this.applicationDeployPropertiesMap.get("domain");
            this.loadDomainDeployProperties(domainName);
        }
        return this.domainDeployPropertiesMap;
    }

    private void loadApplicationDeployProperties() {
        this.applicationDeployPropertiesMap = new HashMap<String, String>();
        URL url = null;
        Enumeration urls = ClassUtils.getResources((String)DEFAULT_MULE_DEPLOY_PROPERTIES_RESOURCE, this.getClass());
        while (urls.hasMoreElements()) {
            URL u = (URL)urls.nextElement();
            if (!this.doesTheFileBelongToTheApplication(u)) continue;
            url = u;
        }
        if (null != url) {
            this.log.debug((Object)("Loaded mule-deploy.properties file from:" + url.getPath().toString()));
            this.loadDeployProperties(url, this.applicationDeployPropertiesMap);
        }
    }

    private void loadDomainDeployProperties(String domainName) {
        this.domainDeployPropertiesMap = new HashMap<String, String>();
        if (StringUtils.isBlank((String)domainName)) {
            this.log.debug((Object)"Attempting to load mule-deploy.properties for a blank domain will return not properties");
        }
        URL url = null;
        Enumeration urls = ClassUtils.getResources((String)DEFAULT_MULE_DEPLOY_PROPERTIES_RESOURCE, this.getClass());
        while (urls.hasMoreElements()) {
            URL u = (URL)urls.nextElement();
            if (!this.doesTheFileBelongToTheDomain(u, domainName)) continue;
            url = u;
        }
        if (null != url) {
            this.log.debug((Object)("Loaded mule-deploy.properties file from:" + url.getPath().toString()));
            this.loadDeployProperties(url, this.domainDeployPropertiesMap);
        }
    }

    private void loadDeployProperties(URL resourceUrl, Map<String, String> propertiesMap) {
        if (null == resourceUrl) {
            this.log.warn((Object)"mule-deploy.properties file was not found");
            return;
        }
        try {
            propertiesMap.putAll(this.loadProperties(resourceUrl));
        }
        catch (IOException e) {
            this.log.warn((Object)"mule-deploy.properties could not be loaded.");
        }
    }

    private boolean doesTheFileBelongToTheApplication(URL url) {
        String path = new File(url.getPath()).getPath();
        return path.contains(this.projectName + MULE_DEPLOY_PROPERTIES_RELATIVE_PATH) || path.contains(this.projectName + MULE_DEPLOY_PROPERTIES_TEST_RELATIVE_PATH);
    }

    private boolean doesTheFileBelongToTheDomain(URL url, String domainName) {
        String domainMuleDeployPropertiesRelativePath = File.separator + domainName + File.separator;
        String path = new File(url.getPath()).getPath();
        return path.contains(domainMuleDeployPropertiesRelativePath);
    }

    private Map<String, String> loadProperties(URL propsFile) throws IOException {
        HashMap<String, String> appPropsMap = new HashMap<String, String>();
        Properties props = this.loadPropertiesFromFile(propsFile);
        for (Object key : props.keySet()) {
            appPropsMap.put(key.toString(), props.getProperty(key.toString()));
        }
        return appPropsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadPropertiesFromFile(URL url) throws IOException {
        Properties props;
        if (url == null) {
            throw new IOException("Invalid file URL!");
        }
        InputStream is = url.openStream();
        try {
            props = new Properties();
            props.load(is);
        }
        finally {
            is.close();
        }
        return props;
    }
}

