/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.output;


import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>Prints the description using different printers</p>
 *
 * @author Mulesoft Inc.
 * @since 3.3.2
 */
public class DefaultOutputHandler implements TestOutputHandler {

    private List<OutputPrinter> printers = new ArrayList<OutputPrinter>();

    public DefaultOutputHandler() {
        printers.add(new ConsolePrinter());
    }

    public DefaultOutputHandler(List<OutputPrinter> printers){
        this.printers = printers;
    }

    @Override
    public void printDescription(String name, String description) {
        String text = "Running " + name;

        this.print(text);

    }

    @Override
    public void printTestName(String suiteName) {
        String title = StringUtils.repeat("=", 40 + FilenameUtils.getName(suiteName).length());
        this.print(title);
        this.print("===========  Running  " + FilenameUtils.getName(suiteName) + "  test ===========");
        this.print(title);
    }

    public List<OutputPrinter> getPrinters() {
        return this.printers;
    }

    private void print(String text) {
        for (OutputPrinter printer : printers) {
            printer.print(text);
        }
    }
}
