/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.mule.result.notification;

import org.mule.munit.runner.mule.MunitTest;
import org.mule.munit.runner.mule.result.SuiteResult;
import org.mule.munit.runner.mule.result.TestResult;

/**
 * The goal of this class is to adapt the old NotificationListener to the SuiteRunnerEventListener in order to keep
 * backward compatibility
 */
public class SuiteRunnerEventListenerAdapter implements SuiteRunnerEventListener {

    private NotificationListener notificationListener;

    public SuiteRunnerEventListenerAdapter(NotificationListener notificationListener) {
        this.notificationListener = notificationListener;
    }

    public void notifyTestStart(MunitTest test) {
        notificationListener.notifyStartOf(test);
    }

    public void notifyTestResult(TestResult testResult) {
        notificationListener.notify(testResult);
    }

    public void notifyTestIgnored(TestResult testResult) {
        notificationListener.notifyIgnored(testResult);
    }

    public void notifySuiteEnd(SuiteResult result) {
        notificationListener.notifyEnd(result);
    }

    public void notifySuiteStart(String path) {
    }

    public void notifyAfterSuiteFailure(Notification notification) {
    }

    public void notifyAfterSuiteError(Notification notification) {
    }

    public void notifyNumberOfTests(int numberOfTests) {
    }

    public void notifySuiteStartFailure(Notification notification) {
    }

    public void notifyBeforeSuiteFailure(Notification notification) {
    }

    public void notifyBeforeSuiteError(Notification notification) {
    }
}