/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.mule.result.notification;


import org.apache.commons.lang3.StringUtils;
import org.mule.munit.runner.mule.MunitTest;
import org.mule.munit.runner.mule.result.SuiteResult;
import org.mule.munit.runner.mule.result.TestResult;

import java.io.PrintStream;

public class StreamSuiteRunnerEventListener implements SuiteRunnerEventListener
{

    private PrintStream out;
    private boolean debugMode = true;

    public StreamSuiteRunnerEventListener(PrintStream out)
    {
        this.out = out;
    }

    public void notifySuiteStart(String name) {
    }

    public void notifyTestStart(MunitTest test)
    {
        out.flush();
    }

    public void notifyNumberOfTests(int numberOfTests) {
    }

    public void notifyTestResult(TestResult testResult)
    {
        Notification notification = null;
        if (testResult.getNumberOfErrors() > 0)
        {
            out.println("ERROR - The test " + testResult.getTestName() + " finished with an Error.");
            out.flush();
            notification = testResult.getError();
        }
        else if (testResult.getFailure() != null)
        {
            out.println("FAILURE - The test " + testResult.getTestName() + " finished with a Failure.");
            out.flush();
            notification = testResult.getFailure();
        }

        if (notification != null)
        {
            out.println(notification.getShortMessage());

            if (debugMode)
            {
                out.println(notification.getFullMessage());
            }
            out.flush();
        }
        else if (testResult.isSkipped())
        {
            out.println("SKIPPED - Test " + testResult.getTestName() + " was Skipped.");
            out.flush();
        }
        else
        {
            out.println("SUCCESS - Test " + testResult.getTestName() + " finished Successfully.");
            out.flush();
        }
    }

    
    @Override
    public void notifyTestIgnored(TestResult testResult) {
        out.flush();
    }

    @Override
    public void notifySuiteEnd(SuiteResult result)
    {
        out.println();
        String title = "Number of tests run: " + result.getNumberOfTests() + " - Failed: " + result.getNumberOfFailures() + " - Errors: " + result.getNumberOfErrors() + " - Skipped: " + result.getNumberOfSkipped() + " - Time elapsed: " + result.getTime() + "ms";
        String titleFrame = StringUtils.repeat("=", title.length());
        out.println(titleFrame);
        out.println(title);
        out.println(titleFrame);
        out.flush();
    }

    public void notifyBeforeSuiteFailure(Notification notification) {

    }

    public void notifyBeforeSuiteError(Notification notification) {

    }

    public void notifyAfterSuiteFailure(Notification notification) {

    }

    public void notifyAfterSuiteError(Notification notification) {

    }

    public void notifySuiteStartFailure(Notification notification) {

    }

    public void setDebugMode(boolean debugMode)
    {
        this.debugMode = debugMode;
    }
}
