/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.mule.result.notification;

import org.mule.munit.runner.mule.MunitTest;
import org.mule.munit.runner.mule.result.SuiteResult;
import org.mule.munit.runner.mule.result.TestResult;

import java.util.ArrayList;
import java.util.List;

public class NotificationListenerDecorator implements NotificationListener {

    private List<NotificationListener> notificationListeners = new ArrayList<NotificationListener>();


    public void notifyRuntimeStartFailure(Notification notification) {

    }

    @Override
    public void notifyStartOf(MunitTest test) {
        for (NotificationListener notificationListener : notificationListeners) {
            notificationListener.notifyStartOf(test);
        }
    }

    @Override
    public void notify(TestResult testResult) {
        for (NotificationListener notificationListener : notificationListeners) {
            notificationListener.notify(testResult);
        }
    }

    @Override
    public void notifyIgnored(TestResult testResult) {
        for (NotificationListener notificationListener : notificationListeners) {
            notificationListener.notifyIgnored(testResult);
        }
    }

    @Override
    public void notifyEnd(SuiteResult result) {
        for (NotificationListener notificationListener : notificationListeners) {
            notificationListener.notifyEnd(result);
        }
    }

    public void addNotificationListener(NotificationListener listener) {
        notificationListeners.add(listener);
    }
}