/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.mule;

import org.mule.munit.runner.mule.result.SuiteResult;
import org.mule.munit.runner.mule.result.TestResult;
import org.mule.munit.runner.mule.result.notification.DummySuiteRunnerEventListener;
import org.mule.munit.runner.mule.result.notification.SuiteRunnerEventListener;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>MUnit Suite</p>
 *
 * @author Mulesoft Inc.
 * @since 3.3.2
 */
public class MunitSuite {

    private String name;
    private List<MunitTest> munitTests = new ArrayList<MunitTest>();
    private SuiteRunnerEventListener suiteRunnerEventListener = new DummySuiteRunnerEventListener();

    public MunitSuite(String name) {
        this.name = name;
    }

    public void add(MunitTest test) {
        munitTests.add(test);
    }

    /**
     * <p>Runs all the tests of the suite </p>
     *
     * @return The Result of the suite execution
     * @throws Exception If the suite failed for one reason.
     */
    public SuiteResult run() throws Exception {
        SuiteResult result = new SuiteResult(name);

        suiteRunnerEventListener.notifyNumberOfTests(getNumberOfTests());

        for (MunitTest test : munitTests) {
            suiteRunnerEventListener.notifyTestStart(test);

            TestResult testResult = test.run();
            result.add(testResult);

            if (testResult.isSkipped()) {
                suiteRunnerEventListener.notifyTestIgnored(testResult);
            }

            suiteRunnerEventListener.notifyTestResult(testResult);
        }

        return result;
    }

    public void setSuiteRunnerEventListener(SuiteRunnerEventListener suiteRunnerEventListener) {
        if (suiteRunnerEventListener == null) {
            throw new IllegalArgumentException();
        }

        this.suiteRunnerEventListener = suiteRunnerEventListener;
    }

    public int getNumberOfTests() {

        return munitTests.size();
    }

    public String getName() {
        return name;
    }
}
