/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.exception;

import org.mule.api.GlobalNameableObject;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.api.processor.MessageProcessorContainer;
import org.mule.api.processor.MessageProcessorPathElement;
import org.mule.munit.common.MunitUtils;

/**
 * The purpose of this class is to by pass Assertion Errors.
 * <p/>
 * Assertion Errors can be thrown by assert MPs during a Spy.
 * In these scenarios, the flow should not wrap that error and just let it pass so the tests invoking the flow can fail.
 *
 * @since 1.1.0
 */
public class MunitMessagingExceptionHandler implements MessagingExceptionHandler, MessageProcessorContainer, GlobalNameableObject, Lifecycle {
    private MessagingExceptionHandler originalMessagingExceptionHandler;

    public MunitMessagingExceptionHandler(MessagingExceptionHandler originalHandler) {
        this.originalMessagingExceptionHandler = originalHandler;
    }

    public MuleEvent handleException(Exception exception, MuleEvent event) {
        MunitUtils.throwRootCauseIfMatches(exception);

        return originalMessagingExceptionHandler.handleException(exception, event);
    }

    public void dispose() {
        ((Lifecycle) originalMessagingExceptionHandler).dispose();
    }

    public void initialise() throws InitialisationException {
        ((Lifecycle) originalMessagingExceptionHandler).initialise();
    }

    public void start() throws MuleException {
        ((Lifecycle) originalMessagingExceptionHandler).start();
    }

    public void stop() throws MuleException {
        ((Lifecycle) originalMessagingExceptionHandler).stop();
    }

    public void addMessageProcessorPathElements(MessageProcessorPathElement pathElement) {
        ((MessageProcessorContainer) originalMessagingExceptionHandler).addMessageProcessorPathElements(pathElement);
    }

    public String getGlobalName() {
        if (originalMessagingExceptionHandler instanceof GlobalNameableObject) {
            return ((GlobalNameableObject) originalMessagingExceptionHandler).getGlobalName();
        }
        return null;
    }

    public void setGlobalName(String name) {
        if (originalMessagingExceptionHandler instanceof GlobalNameableObject) {
            ((GlobalNameableObject) originalMessagingExceptionHandler).setGlobalName(name);
        }
    }
}
