/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.construct.FlowConstruct;
import org.mule.munit.assertion.processors.MunitAfterSuite;
import org.mule.munit.assertion.processors.MunitBeforeSuite;
import org.mule.munit.assertion.processors.MunitFlow;
import org.mule.munit.runner.MuleContextManager;
import org.mule.munit.runner.MuleEventBuilderWrapper;
import org.mule.munit.runner.exception.BeforeSuiteException;
import org.mule.munit.runner.exception.FlowException;
import org.mule.munit.runner.mule.MunitTest;
import org.mule.munit.runner.mule.result.notification.DummySuiteRunnerEventListener;
import org.mule.munit.runner.mule.result.notification.Notification;
import org.mule.munit.runner.mule.result.notification.SuiteRunnerEventListener;
import org.mule.munit.runner.output.TestOutputHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MunitRunner<T> {
    private transient Log logger = LogFactory.getLog(this.getClass());
    private TestOutputHandler handler;
    private MuleContext muleContext;
    private MuleContextManager muleContextManager;
    private SuiteRunnerEventListener suiteRunnerEventListener = new DummySuiteRunnerEventListener();

    public MunitRunner(TestOutputHandler handler, MuleContextManager muleContextManager, MuleContext muleContext) {
        this.handler = handler;
        this.muleContext = muleContext;
        this.muleContextManager = muleContextManager;
    }

    protected abstract T runSuite() throws Exception;

    protected abstract String getSuiteName();

    public T run() {
        this.logger.debug((Object)("About to run MUnit suite: " + this.getSuiteName() + " ..."));
        this.handler.printTestName(this.getSuiteName());
        try {
            this.processBeforeSuites();
            T result = this.runSuite();
            this.logger.debug((Object)("Tests in MUnit suite: " + this.getSuiteName() + " run"));
            T t = result;
            return t;
        }
        catch (BeforeSuiteException e) {
            this.logger.error((Object)"Before suites execution failed", e.getCause());
            throw new RuntimeException("Before suites execution failed", e.getCause());
        }
        catch (Throwable e) {
            this.logger.error((Object)("Could not Run the suite: " + this.getSuiteName()), e);
            throw new RuntimeException("Could not Run the suite", e);
        }
        finally {
            this.processAfterSuites();
        }
    }

    public void setSuiteRunnerEventListener(SuiteRunnerEventListener suiteRunnerEventListener) {
        this.suiteRunnerEventListener = suiteRunnerEventListener;
    }

    private void processBeforeSuites() {
        try {
            this.logger.debug((Object)"Executing Before Suite scopes...");
            List<MunitFlow> beforeSuites = this.lookupFlows(MunitBeforeSuite.class);
            if (!beforeSuites.isEmpty()) {
                this.process(beforeSuites, this.muleEvent((FlowConstruct)beforeSuites.get(0)));
            }
        }
        catch (FlowException flowException) {
            Throwable e = flowException.getCause();
            Notification notification = this.getNotification(e, String.format("Before suite %s failed", flowException.getFlowName()));
            if (e instanceof AssertionError) {
                this.suiteRunnerEventListener.notifyBeforeSuiteFailure(notification);
            } else {
                this.suiteRunnerEventListener.notifyBeforeSuiteError(notification);
            }
            throw new BeforeSuiteException(e);
        }
    }

    private void processAfterSuites() {
        try {
            this.logger.debug((Object)"Executing After Suite scopes...");
            List<MunitFlow> afterSuites = this.lookupFlows(MunitAfterSuite.class);
            if (!afterSuites.isEmpty()) {
                this.process(afterSuites, this.muleEvent((FlowConstruct)afterSuites.get(0)));
            }
        }
        catch (FlowException flowException) {
            Throwable e = flowException.getCause();
            this.logger.error((Object)"After suites execution failed", e);
            Notification notification = this.getNotification(e, String.format("After suite %s failed", flowException.getFlowName()));
            if (e instanceof AssertionError) {
                this.suiteRunnerEventListener.notifyAfterSuiteFailure(notification);
            } else {
                this.suiteRunnerEventListener.notifyAfterSuiteError(notification);
            }
            throw new RuntimeException("After suites execution failed", e);
        }
        finally {
            this.muleContextManager.killMule(this.muleContext);
        }
    }

    private MuleEvent muleEvent(FlowConstruct flowConstruct) {
        return MuleEventBuilderWrapper.muleEvent(this.muleContext, flowConstruct);
    }

    private void process(Collection<MunitFlow> flowConstructs, MuleEvent event) throws FlowException {
        String flowName = "";
        try {
            for (MunitFlow flowConstruct : flowConstructs) {
                flowName = flowConstruct.getName();
                this.handler.printDescription(flowName, flowConstruct.getDescription());
                flowConstruct.process(event);
            }
        }
        catch (Throwable e) {
            throw new FlowException(flowName, e);
        }
    }

    private List<MunitFlow> lookupFlows(Class<? extends MunitFlow> munitClass) {
        return new ArrayList<MunitFlow>(this.muleContext.getRegistry().lookupObjects(munitClass));
    }

    private Notification getNotification(Throwable cause, String message) {
        RuntimeException e = new RuntimeException(message, cause);
        return new Notification(e.getMessage(), MunitTest.stack2string(e));
    }
}

