/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.coverage.model;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.common.util.Preconditions;
import org.mule.munit.remote.coverage.server.ComponentIdentifier;

public class CoverageComponentIdentifierReport
implements ComponentIdentifier,
Serializable {
    private static final long serialVersionUID = -7904681927277956932L;
    private String namespace;
    private String name;
    public static final String CORE_PREFIX = "mule";

    public CoverageComponentIdentifierReport(String namespace, String name) {
        Preconditions.checkArgument((namespace != null && !namespace.trim().isEmpty() ? 1 : 0) != 0, (String)"Prefix URI must be not blank");
        Preconditions.checkArgument((name != null && !name.trim().isEmpty() ? 1 : 0) != 0, (String)"Name must be not blank");
        this.namespace = namespace;
        this.name = name;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoverageComponentIdentifierReport that = (CoverageComponentIdentifierReport)o;
        if (!this.getNamespace().equalsIgnoreCase(that.getNamespace())) {
            return false;
        }
        return this.getName().equals(that.getName());
    }

    public int hashCode() {
        int result = this.getNamespace().toLowerCase().hashCode();
        result = 31 * result + this.getName().hashCode();
        return result;
    }

    public String toString() {
        return this.getNamespace().equals(CORE_PREFIX) ? this.getName() : this.getNamespace() + ":" + this.getName();
    }

    public static CoverageComponentIdentifierReport fromComponentIdentifier(ComponentIdentifier identifier) {
        return new CoverageComponentIdentifierReport(identifier.getNamespace(), identifier.getName());
    }

    public static CoverageComponentIdentifierReport parseComponentIdentifier(String componentIdentifier) {
        String identifier;
        String namespace;
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)componentIdentifier) ? 1 : 0) != 0, (String)"identifier cannot be an empty string or null");
        String[] values = componentIdentifier.split(":");
        if (values.length == 2) {
            namespace = values[0];
            identifier = values[1];
        } else {
            namespace = CORE_PREFIX;
            identifier = values[0];
        }
        return new CoverageComponentIdentifierReport(namespace, identifier);
    }
}

