/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.internal;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.mule.maven.client.internal.MavenEnvironmentVariables;

public class MavenCommandLineParser {
    private MavenCommandLineParser() {
    }

    public static MavenArguments parseMavenArguments(MavenEnvironmentVariables mavenEnvironmentVariables) {
        MavenArguments mavenArguments = new MavenArguments();
        JCommander.newBuilder().addObject((Object)mavenArguments).acceptUnknownOptions(true).allowParameterOverwriting(true).build().parse(MavenCommandLineParser.getMavenCmdLineArgs(mavenEnvironmentVariables));
        return mavenArguments;
    }

    private static String[] getMavenCmdLineArgs(MavenEnvironmentVariables mavenEnvironmentVariables) {
        String mavenCmdLineArgs = mavenEnvironmentVariables.getMavenCmdLineArgsEnv();
        if (mavenCmdLineArgs != null) {
            return mavenCmdLineArgs.trim().split(" ");
        }
        return new String[0];
    }

    public static class MavenArguments {
        @Parameter(names={"-s", "--settings"}, description="User settings")
        private List<File> settings = new ArrayList<File>();
        @Parameter(names={"-gs", "--global-settings"}, description="Global settings")
        private List<File> globalSettings = new ArrayList<File>();
        @Parameter(names={"-C", "--strict-checksums"}, description="Strict checksums")
        private boolean strictChecksums = false;
        @Parameter(names={"-c", "--lax-checksums"}, description="Lax checksums")
        private boolean laxChecksums = false;

        public Optional<File> getSettings() {
            return Optional.ofNullable(this.settings.size() >= 1 ? this.settings.get(0) : null);
        }

        public Optional<File> getGlobalSettings() {
            return Optional.ofNullable(this.globalSettings.size() >= 1 ? this.globalSettings.get(0) : null);
        }

        public boolean isStrictChecksums() {
            return this.strictChecksums;
        }

        public boolean isLaxChecksums() {
            return this.laxChecksums;
        }
    }
}

