/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.coverage.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import org.mule.munit.remote.coverage.model.CoverageLocationPartReport;
import org.mule.munit.remote.coverage.server.ComponentLocation;
import org.mule.munit.remote.coverage.server.LocationPart;

public class CoverageComponentLocationReport
implements ComponentLocation,
Serializable {
    private static final long serialVersionUID = 4958158607813720623L;
    private final String name;
    private final LinkedList<CoverageLocationPartReport> parts;
    private volatile String location;

    public CoverageComponentLocationReport(Optional<String> name, List<CoverageLocationPartReport> parts) {
        this.name = name.orElse(null);
        this.parts = new LinkedList<CoverageLocationPartReport>(parts);
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    @Override
    public List<LocationPart> getParts() {
        return Collections.unmodifiableList(this.parts);
    }

    @Override
    public Optional<String> getFileName() {
        return this.parts.getLast().getFileName();
    }

    @Override
    public Optional<Integer> getLineInFile() {
        return this.parts.getLast().getLineInFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLocation() {
        if (this.location == null) {
            CoverageComponentLocationReport coverageComponentLocationReport = this;
            synchronized (coverageComponentLocationReport) {
                if (this.location == null) {
                    StringBuilder locationBuilder = new StringBuilder();
                    for (CoverageLocationPartReport part : this.parts) {
                        locationBuilder.append("/").append(part.getPartPath());
                    }
                    this.location = locationBuilder.replace(0, 1, "").toString();
                }
            }
        }
        return this.location;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoverageComponentLocationReport that = (CoverageComponentLocationReport)o;
        if (this.getName() != null ? !this.getName().equals(that.getName()) : that.getName() != null) {
            return false;
        }
        if (!this.getParts().equals(that.getParts())) {
            return false;
        }
        return this.getLocation() != null ? this.getLocation().equals(that.getLocation()) : that.getLocation() == null;
    }

    public int hashCode() {
        int result = this.getName() != null ? this.getName().hashCode() : 0;
        result = 31 * result + this.getParts().hashCode();
        result = 31 * result + (this.getLocation() != null ? this.getLocation().hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DefaultComponentLocation{name='" + this.name + '\'' + ", parts=" + this.parts + ", location='" + this.getLocation() + '\'' + '}';
    }

    @Override
    public Optional<Integer> getStartColumn() {
        return Optional.empty();
    }

    @Override
    public OptionalInt getLine() {
        return OptionalInt.empty();
    }

    @Override
    public OptionalInt getColumn() {
        return OptionalInt.empty();
    }
}

