/*
 * Decompiled with CFR 0.152.
 */
package de.vandermeer.asciilist;

import de.vandermeer.asciilist.AsciiList;
import de.vandermeer.asciilist.AsciiListItem;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrBuilder;
import org.apache.commons.lang3.text.WordUtils;

public abstract class AbstractAsciiList
implements AsciiList {
    protected List<Object> items = new ArrayList<Object>();
    protected int preLabelIndent;
    protected int postLabelIndent;
    protected String preLabelStr;
    protected String postLabelStr;
    protected int level = 1;
    protected final boolean isContinued;
    protected int maxItemIndent = 0;
    protected int width = -1;

    public AbstractAsciiList() {
        this(true);
    }

    public AbstractAsciiList(AbstractAsciiList list) {
        this(list.isContinued);
        this.preLabelIndent = list.preLabelIndent;
        this.postLabelIndent = list.postLabelIndent;
        this.preLabelStr = list.preLabelStr;
        this.postLabelStr = list.postLabelStr;
        this.level = list.level;
        this.items.addAll(list.items);
    }

    public AbstractAsciiList(boolean isContinued) {
        this.isContinued = isContinued;
        this.setLabelDefaults();
    }

    @Override
    public AsciiList setLabelDefaults() {
        this.preLabelIndent = 1;
        this.postLabelIndent = 1;
        this.preLabelStr = "";
        this.postLabelStr = "";
        return this;
    }

    @Override
    public int calculateMaxIndentation() {
        int position = 0;
        for (int i = 0; i < this.items.size(); ++i) {
            int indent;
            if (!(this.items.get(i) instanceof AsciiListItem) || this.maxItemIndent >= (indent = this.calculateMaxIndentation((AsciiListItem)this.items.get(i), ++position))) continue;
            this.maxItemIndent = indent;
        }
        return this.maxItemIndent;
    }

    @Override
    public List<Object> getItems() {
        return this.items;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public int getPostLabelIndent() {
        return this.postLabelIndent;
    }

    @Override
    public String getPostLabelString() {
        return this.postLabelStr;
    }

    @Override
    public int getPreLabelIndent() {
        return this.preLabelIndent;
    }

    @Override
    public String getPreLabelString() {
        return this.preLabelStr;
    }

    @Override
    public boolean isContinuedList() {
        return this.isContinued;
    }

    @Override
    public String render() {
        this.prepareRender();
        StrBuilder ret = new StrBuilder(100);
        this.maxItemIndent = 0;
        this.calculateMaxIndentation();
        if (this.width > 0 && this.maxItemIndent + 6 > this.width) {
            throw new IllegalArgumentException("width <" + this.width + "> is to small for list content with indentation already at <" + this.maxItemIndent + ">");
        }
        int position = 0;
        for (int i = 0; i < this.items.size(); ++i) {
            if (this.items.get(i) instanceof AsciiListItem) {
                ret.appendSeparator("\n").append(this.wrapItem(this.renderItem((AsciiListItem)this.items.get(i), ++position)));
                continue;
            }
            if (this.items.get(i) instanceof AsciiList) {
                AsciiList l = (AsciiList)this.items.get(i);
                l.setPreLabelIndent(this.maxItemIndent);
                ret.appendSeparator("\n").append(l.render());
                continue;
            }
            throw new NotImplementedException("not yet implemented, only AsciiList and AsciiListItem supported");
        }
        return ret.toString();
    }

    @Override
    public AsciiList setLevel(int level) {
        if (level > 1) {
            this.level = level;
        }
        return this;
    }

    @Override
    public void prepareRender() {
        for (Object obj : this.items) {
            if (!(obj instanceof AsciiList)) continue;
            ((AsciiList)obj).setLevel(this.level + 1);
            ((AsciiList)obj).setWidth(this.width);
        }
    }

    @Override
    public AsciiList setPostLabelIndent(int indent) {
        if (indent > -1) {
            this.postLabelIndent = indent;
        }
        return this;
    }

    @Override
    public AsciiList setPostLabelString(String str) {
        this.postLabelStr = str;
        return this;
    }

    @Override
    public AsciiList setPreLabelIndent(int indent) {
        if (indent > -1) {
            this.preLabelIndent = indent;
        }
        return this;
    }

    @Override
    public AsciiList setPreLabelString(String str) {
        this.preLabelStr = str;
        return this;
    }

    @Override
    public AsciiList setWidth(int width) {
        this.width = width;
        return this;
    }

    protected String wrapItem(String renderedItem) {
        String ret = "";
        if (renderedItem.contains("@@@@")) {
            String[] split = StringUtils.split((String)renderedItem, (String)"@@@@");
            String rest = StringUtils.repeat((String)" ", (int)this.maxItemIndent) + split[1];
            if (this.width > 0 && rest.length() < this.width) {
                return split[0] + "\n" + rest;
            }
            if (this.width < 0) {
                return split[0] + "\n" + rest;
            }
        }
        if (this.width > 0 && renderedItem.length() > this.width) {
            Object[] wrap = StringUtils.split((String)WordUtils.wrap((String)renderedItem, (int)(this.width - this.preLabelIndent - this.preLabelStr.length()), (String)"@@@@", (boolean)true), (String)"@@@@");
            ret = ret + StringUtils.repeat((String)" ", (int)this.preLabelIndent) + StringUtils.repeat((String)" ", (int)this.preLabelStr.length()) + wrap[0];
            if (wrap.length > 1) {
                ret = ret + "\n" + this.wrapItemNextLine(StringUtils.repeat((String)" ", (int)this.maxItemIndent) + StringUtils.join((Object[])ArrayUtils.remove((Object[])wrap, (int)0), (String)" "));
            }
            return ret;
        }
        return renderedItem;
    }

    protected String wrapItemNextLine(String str) {
        Object[] wrap = StringUtils.split((String)WordUtils.wrap((String)str, (int)(this.width - this.maxItemIndent), (String)"@@@@", (boolean)true), (String)"@@@@");
        String ret = StringUtils.repeat((String)" ", (int)this.maxItemIndent) + wrap[0];
        if (wrap.length == 1) {
            return ret;
        }
        return ret + "\n" + this.wrapItemNextLine(StringUtils.repeat((String)" ", (int)this.maxItemIndent) + StringUtils.join((Object[])ArrayUtils.remove((Object[])wrap, (int)0), (String)" "));
    }
}

