/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.remote.coverage.printer.model;


import java.util.ArrayList;
import java.util.List;

import org.mule.munit.remote.coverage.model.ApplicationCoverageReport;
import org.mule.munit.remote.coverage.model.CoverageLimits;

/**
 * <p>
 * Model that represents a Coverage Report.
 * </p>
 * 
 * @author Mulesoft Inc.
 * @since 1.0.0
 */
public class CoverageReportModel {

  private double coverage;
  private double requiredApplicationCoverage;
  private double requiredResourceCoverage;
  private double requiredFlowCoverage;
  private int flowCount;
  private int processorCount;
  private int coveredProcessorCount;
  private List<MuleResourceModel> files = new ArrayList<>();

  public CoverageReportModel(ApplicationCoverageReport report, CoverageLimits coverageLimits) {
    this.coverage = report.getCoverage();
    this.flowCount = report.getApplicationFlowCount();
    this.processorCount = report.getApplicationMessageProcessorCount();
    this.coveredProcessorCount = report.getApplicationCoveredMessageProcessorCount();
    this.requiredApplicationCoverage = coverageLimits.getRequiredApplicationCoverage();
    this.requiredResourceCoverage = coverageLimits.getRequiredResourceCoverage();
    this.requiredFlowCoverage = coverageLimits.getRequiredFlowCoverage();
  }

  public double getCoverage() {
    return coverage;
  }

  public void setCoverage(double coverage) {
    this.coverage = coverage;
  }

  public List<MuleResourceModel> getFiles() {
    return files;
  }

  public void setFiles(List<MuleResourceModel> files) {
    this.files = files;
  }

  public double getRequiredApplicationCoverage() {
    return requiredApplicationCoverage;
  }

  public void setRequiredApplicationCoverage(double requiredApplicationCoverage) {
    this.requiredApplicationCoverage = requiredApplicationCoverage;
  }

  public double getRequiredFlowCoverage() {
    return requiredFlowCoverage;
  }

  public void setRequiredFlowCoverage(double requiredFlowCoverage) {
    this.requiredFlowCoverage = requiredFlowCoverage;
  }

  public double getRequiredResourceCoverage() {
    return requiredResourceCoverage;
  }

  public void setRequiredResourceCoverage(double requiredResourceCoverage) {
    this.requiredResourceCoverage = requiredResourceCoverage;
  }

  public int getFlowCount() {
    return flowCount;
  }

  public void setFlowCount(int flowCount) {
    this.flowCount = flowCount;
  }

  public int getProcessorCount() {
    return processorCount;
  }

  public void setProcessorCount(int processorCount) {
    this.processorCount = processorCount;
  }

  public int getCoveredProcessorCount() {
    return coveredProcessorCount;
  }

  public void setCoveredProcessorCount(int coveredProcessorCount) {
    this.coveredProcessorCount = coveredProcessorCount;
  }
}
