/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
/*
* Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
* copyright law. All use of this software is subject to MuleSoft's Master Subscription
* Agreement (or other master license agreement) separately entered into in writing between
* you and MuleSoft. If such an agreement is not in place, you may not use the software.
*/

package org.mule.munit.remote.api.configuration;

import static org.mule.munit.common.util.Preconditions.checkArgument;
import static org.mule.munit.common.util.Preconditions.checkNotNull;
import static java.lang.Boolean.FALSE;
import static java.util.Collections.emptySet;

import java.util.Set;

/**
 * <p>
 * Define the configuration for the coverage calculation
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class CoverageConfiguration {

  public static final int ILLEGAL_PORT_NUMBER = -1;

  private Boolean runCoverage;

  private Boolean randomizeCoveragePort = true;
  private Integer coveragePort = ILLEGAL_PORT_NUMBER;

  private Set<String> suitePaths = emptySet();
  private Set<String> ignoredFiles = emptySet();
  private Set<String> ignoredFlowNames = emptySet();

  private CoverageConfiguration(Boolean runCoverage, Set<String> suitePaths, Set<String> ignoredFlowNames,
                                Set<String> ignoredFiles, Boolean randomizeCoveragePort, Integer coveragePort) {

    this.runCoverage = runCoverage;
    this.suitePaths = suitePaths;
    this.ignoredFlowNames = ignoredFlowNames;
    this.ignoredFiles = ignoredFiles;
    this.randomizeCoveragePort = randomizeCoveragePort;
    this.coveragePort = coveragePort;
  }

  public Boolean isRunCoverage() {
    return runCoverage;
  }

  public Set<String> getSuitePaths() {
    return suitePaths;
  }

  public Set<String> getIgnoredFlowNames() {
    return ignoredFlowNames;
  }

  public Set<String> getIgnoredFiles() {
    return ignoredFiles;
  }

  public Integer getCoveragePort() {
    return coveragePort;
  }

  public Boolean isRandomizeCoveragePort() {
    return randomizeCoveragePort;
  }

  /**
   * Coverage Configuration Builder
   *
   * @author Mulesoft Inc.
   * @since 2.0.0
   */
  public static class CoverageConfigurationBuilder {

    private Boolean runCoverage = FALSE;

    private Set<String> suitePaths = emptySet();
    private Set<String> ignoredFiles = emptySet();
    private Set<String> ignoredFlowNames = emptySet();

    private Integer coveragePort;
    private Boolean randomizeCoveragePort = true;

    public CoverageConfigurationBuilder withShouldRunCoverage(Boolean shouldRunCoverage) {
      checkNotNull(runCoverage, "runCoverage must not be null");
      this.runCoverage = shouldRunCoverage;
      return this;
    }

    public CoverageConfigurationBuilder withSuitePaths(Set<String> suitePaths) {
      checkNotNull(suitePaths, "Suite path list  must not be null");
      this.suitePaths = suitePaths;
      return this;
    }

    public CoverageConfigurationBuilder withIgnoredFlowNames(Set<String> ignoredFlowNames) {
      checkNotNull(ignoredFlowNames, "Ignored Flow Names list must not be null");
      this.ignoredFlowNames = ignoredFlowNames;
      return this;
    }

    public CoverageConfigurationBuilder withIgnoredFiles(Set<String> ignoredFiles) {
      checkNotNull(ignoredFiles, "Ignored files must not be null");
      this.ignoredFiles = ignoredFiles;
      return this;
    }

    public CoverageConfigurationBuilder withCoveragePort(Integer coveragePort) {
      checkNotNull(coveragePort, "Coverage port must not be null");
      checkArgument(coveragePort > 0, "Coverage port must be a positive number");
      this.coveragePort = coveragePort;
      this.randomizeCoveragePort = false;
      return this;
    }

    public CoverageConfiguration build() {
      return new CoverageConfiguration(runCoverage, suitePaths, ignoredFlowNames, ignoredFiles, randomizeCoveragePort,
                                       coveragePort);
    }
  }
}
