/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.coverage.printer.model;

import java.util.List;
import java.util.Vector;
import org.mule.munit.remote.coverage.model.MuleFlow;
import org.mule.munit.remote.coverage.model.MuleFlowLine;
import org.mule.munit.remote.coverage.model.MuleLocation;

public class MuleFlowModel {
    private String name;
    private String type;
    private double coverage;
    private int messageProcessorCount;
    private int coveredProcessorCount;
    private List<MuleFlowLine> lines;

    public MuleFlowModel(MuleFlow flow) {
        this.coverage = flow.getCoverage();
        this.name = flow.getName();
        this.type = flow.getType();
        this.messageProcessorCount = flow.getLocations().size();
        this.coveredProcessorCount = flow.getCoveredLocations().size();
        this.lines = this.getFlowLines(flow);
    }

    private List<MuleFlowLine> getFlowLines(MuleFlow flow) {
        Vector<Integer> coveredLines = new Vector<Integer>();
        for (MuleLocation coveredLocation : flow.getCoveredLocations()) {
            coveredLines.add(coveredLocation.getLineNumber());
        }
        Vector<MuleFlowLine> flowLines = new Vector<MuleFlowLine>();
        for (MuleLocation location : flow.getLocations()) {
            boolean isLineCovered = coveredLines.contains(location.getLineNumber());
            MuleFlowLine line = new MuleFlowLine(location.getLineNumber(), isLineCovered);
            flowLines.add(line);
        }
        return flowLines;
    }

    public double getCoverage() {
        return this.coverage;
    }

    public void setCoverage(double coverage) {
        this.coverage = coverage;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getProcessorCount() {
        return this.messageProcessorCount;
    }

    public void setProcessorCount(int processorCount) {
        this.messageProcessorCount = processorCount;
    }

    public int getMessageProcessorCount() {
        return this.coveredProcessorCount;
    }

    public void setCoveredProcessorCount(int coveredProcessorCount) {
        this.coveredProcessorCount = coveredProcessorCount;
    }

    public List<MuleFlowLine> getLines() {
        return this.lines;
    }

    public void setLines(List<MuleFlowLine> lines) {
        this.lines = lines;
    }
}

