/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.coverage.server;

import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.mule.munit.common.util.Preconditions;
import org.mule.munit.remote.coverage.server.ComponentIdentifier;

public final class IdentifierParsingUtils {
    private static final String SEPARATOR = ":";

    private IdentifierParsingUtils() {
    }

    public static ComponentIdentifier parseComponentIdentifier(String stringRepresentation, String defaultNamespace) {
        return IdentifierParsingUtils.parseIdentifier(stringRepresentation, defaultNamespace, false);
    }

    private static ComponentIdentifier parseIdentifier(String stringRepresentation, String defaultNamespace, boolean toUpperCase) {
        String identifier;
        String namespace;
        Preconditions.checkArgument((!StringUtils.isEmpty((String)stringRepresentation) ? 1 : 0) != 0, (String)"identifier cannot be an empty string or null");
        String[] values = stringRepresentation.split(SEPARATOR);
        if (values.length == 2) {
            namespace = values[0];
            identifier = values[1];
        } else {
            namespace = defaultNamespace;
            identifier = values[0];
        }
        if (toUpperCase) {
            namespace = namespace.toUpperCase(Locale.getDefault());
            identifier = identifier.toUpperCase(Locale.getDefault());
        }
        return ComponentIdentifier.builder().namespace(namespace).name(identifier).build();
    }
}

