/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.notifiers;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.Socket;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.common.protocol.notifiers.RunMessageNotifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketNotifier
extends RunMessageNotifier {
    private transient Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private String host;
    private Integer port;
    private ObjectOutputStream out;

    public void init() throws Exception {
        String socketHost = StringUtils.isEmpty((CharSequence)this.host) ? "localhost" : this.host;
        Socket requestSocket = new Socket(socketHost, (int)this.port);
        this.out = new ObjectOutputStream(requestSocket.getOutputStream());
        this.logger.info("Connected to localhost on port " + this.port);
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(String port) {
        this.port = Integer.valueOf(port);
    }

    public void sendMessage(String message) {
        try {
            this.out.writeObject(message);
            this.out.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

