/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.ParseException;
import org.mule.munit.common.properties.MUnitUserPropertiesManager;
import org.mule.munit.common.protocol.listeners.RemoteRunEventListener;
import org.mule.munit.common.protocol.listeners.RunEventListener;
import org.mule.munit.common.protocol.listeners.RunEventListenerContainer;
import org.mule.munit.common.util.StackTraceUtil;
import org.mule.munit.remote.SuiteRunDispatcherFactory;
import org.mule.munit.remote.api.configuration.NotifierConfiguration;
import org.mule.munit.remote.api.configuration.RunConfiguration;
import org.mule.munit.remote.api.configuration.RunConfigurationParser;
import org.mule.munit.remote.classloading.ClassLoaderUtils;
import org.mule.munit.remote.container.ContainerFactoryException;
import org.mule.munit.remote.container.EmbeddedContainerFactory;
import org.mule.munit.remote.container.SuiteRunDispatcher;
import org.mule.munit.remote.exception.DeploymentException;
import org.mule.munit.remote.notifier.NotifierReflectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteRunner {
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String MUNIT_DEPLOYMENT_USERNAME = "munit.deployment.username";
    public static final String MUNIT_DEPLOYMENT_PASSWORD = "munit.deployment.password";
    public static final String SYSTEM_PROPERTIES_FILE = "munit.system.properties.file";
    public static final String MUNIT_DEBUG_LOG_CLASSPATH = "munit.debug.log.classpath";
    private EmbeddedContainerFactory containerFactory;

    public static void main(String[] args) throws ParseException, IOException, URISyntaxException {
        RemoteRunner.loadSystemProperties();
        RunConfiguration runConfig = new RunConfigurationParser().parse(args);
        RemoteRunner runner = new RemoteRunner();
        runner.setContainerFactory(new EmbeddedContainerFactory());
        runner.run(runConfig);
        RemoteRunner.shutDown();
    }

    public void setContainerFactory(EmbeddedContainerFactory containerFactory) {
        this.containerFactory = containerFactory;
    }

    public void run(RunConfiguration runConfig) throws IOException {
        this.logger.info("Run Started");
        this.logClassPathIfNecessary();
        RemoteRunEventListener listener = this.buildRunnerListener(runConfig.getNotifierConfigurations());
        listener.notifyRunStart();
        try {
            SuiteRunDispatcher suiteRunDispatcher = this.buildSuiteRunDispatcher(runConfig);
            suiteRunDispatcher.runSuites(listener);
        }
        catch (ContainerFactoryException e) {
            listener.notifyUnexpectedError(StackTraceUtil.getStackTrace((Throwable)e));
            listener.notifyRunFinish();
            this.logger.info("Done");
            return;
        }
        catch (DeploymentException e) {
            listener.notifyContainerFailure(StackTraceUtil.getStackTrace((Throwable)e));
        }
        catch (Throwable e) {
            e.printStackTrace();
            listener.notifyUnexpectedError(StackTraceUtil.getStackTrace((Throwable)e));
        }
        listener.notifyRunFinish();
        this.logger.info("Done");
    }

    protected SuiteRunDispatcher buildSuiteRunDispatcher(RunConfiguration runConfig) throws ContainerFactoryException {
        return new SuiteRunDispatcherFactory(runConfig, this.containerFactory).create();
    }

    protected RemoteRunEventListener buildRunnerListener(List<NotifierConfiguration> configurations) {
        List<RunEventListener> listeners = new NotifierReflectionFactory().createNotifiers(configurations);
        RunEventListenerContainer container = new RunEventListenerContainer();
        listeners.forEach(arg_0 -> ((RunEventListenerContainer)container).addNotificationListener(arg_0));
        return container;
    }

    private void logClassPathIfNecessary() {
        if (Boolean.valueOf(System.getProperty(MUNIT_DEBUG_LOG_CLASSPATH, "false")).booleanValue()) {
            this.logger.info("logging classpath ...");
            new ClassLoaderUtils().getClassPath().forEach(System.out::println);
            this.logger.info("logging classpath DONE");
        }
    }

    private static void loadSystemProperties() {
        RemoteRunner.loadSystemPropertiesFileIfPresent();
    }

    private static void loadSystemPropertiesFileIfPresent() {
        String filePath = System.getProperty(SYSTEM_PROPERTIES_FILE);
        try {
            if (filePath != null) {
                Properties properties = new Properties();
                properties.load(new FileInputStream(new File(filePath)));
                MUnitUserPropertiesManager.loadPropertiesToSystem((Properties)properties);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void shutDown() {
        System.exit(0);
    }
}

