/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote;

import com.google.common.base.Strings;
import java.io.File;
import java.util.Set;
import org.mule.munit.remote.api.configuration.CloudHubContainerConfiguration;
import org.mule.munit.remote.api.configuration.DeploymentType;
import org.mule.munit.remote.api.configuration.RunConfiguration;
import org.mule.munit.remote.container.ContainerSuiteRunDispatcher;
import org.mule.munit.remote.container.EmbeddedContainerFactory;
import org.mule.munit.remote.container.SuiteRunDispatcher;
import org.mule.munit.remote.container.SuiteRunLocator;
import org.mule.munit.remote.container.cloudhub.CloudHubRunDispatcher;
import org.mule.munit.remote.container.model.SuiteRun;
import org.mule.munit.remote.logging.MunitDeployerLog;
import org.mule.munit.remote.tools.client.BAT.BATClient;
import org.mule.tools.client.authentication.AuthenticationServiceClient;
import org.mule.tools.client.authentication.model.AnypointCredential;
import org.mule.tools.client.authentication.model.Credentials;
import org.mule.tools.client.cloudhub.CloudHubClient;
import org.mule.tools.model.anypoint.CloudHubDeployment;
import org.mule.tools.utils.DeployerLog;

public class SuiteRunDispatcherFactory {
    private final RunConfiguration runConfiguration;
    private final EmbeddedContainerFactory embeddedContainerFactory;

    public SuiteRunDispatcherFactory(RunConfiguration runConfiguration, EmbeddedContainerFactory embeddedContainerFactory) {
        this.runConfiguration = runConfiguration;
        this.embeddedContainerFactory = embeddedContainerFactory;
    }

    public SuiteRunDispatcher create() {
        switch (this.getDeploymentType()) {
            case CLOUDHUB: {
                String username = System.getProperty("munit.deployment.username");
                String password = System.getProperty("munit.deployment.password");
                if (Strings.isNullOrEmpty((String)username) || Strings.isNullOrEmpty((String)password)) {
                    throw new RuntimeException("The username or password must not be null nor empty");
                }
                CloudHubContainerConfiguration containerConfiguration = (CloudHubContainerConfiguration)this.runConfiguration.getContainerConfiguration();
                CloudHubDeployment cloudHubDeployment = (CloudHubDeployment)containerConfiguration.getDeploymentConfiguration().getDeployment();
                cloudHubDeployment.setUsername(username);
                cloudHubDeployment.setPassword(password);
                CloudHubClient cloudHubClient = new CloudHubClient(cloudHubDeployment, (DeployerLog)new MunitDeployerLog(containerConfiguration.isDebugEnabled()));
                BATClient batClient = new BATClient(cloudHubDeployment.getUri(), (AnypointCredential)new Credentials(username, password), new AuthenticationServiceClient(cloudHubDeployment.getUri(), Boolean.valueOf(true)));
                return new CloudHubRunDispatcher(this.runConfiguration, cloudHubClient, batClient);
            }
        }
        File appDir = new File(this.runConfiguration.getContainerConfiguration().getMunitWorkingDirectoryPath(), this.runConfiguration.getProjectName());
        Set<SuiteRun> suiteRuns = new SuiteRunLocator(this.runConfiguration, appDir).locate();
        return new ContainerSuiteRunDispatcher(this.embeddedContainerFactory.createContainer(this.runConfiguration), this.runConfiguration, suiteRuns, appDir);
    }

    private DeploymentType getDeploymentType() {
        return this.runConfiguration.getContainerConfiguration().getType();
    }
}

