/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.remote.properties.deploy;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Sets a system property with a temporary directory location
 *
 * @author Mulesoft Inc.
 * @since 2.2.0
 */
public class TemporaryFolderProperties implements DeploymentProperties {

  protected static final String MUNIT_TEMP_DIR_PROPERTY = "munit.temporary.directory";
  protected static final String MUNIT_TEMP_DIR_PREFIX = "munit-temp-dir";
  protected static final transient Logger LOGGER = LoggerFactory.getLogger(TemporaryFolderProperties.class);

  @Override
  public Map<String, String> get() {
    try {
      Path temporaryDirectory = Files.createTempDirectory(MUNIT_TEMP_DIR_PREFIX);
      LOGGER.debug("Temporary directory created in {}", temporaryDirectory);
      return Collections.singletonMap(MUNIT_TEMP_DIR_PROPERTY, temporaryDirectory.toString());
    } catch (IOException e) {
      LOGGER.error("Unable to create temporary folder", e);
      return Collections.emptyMap();
    }
  }
}
