/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.remote.logging;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Logger for Cloudhub test Deployer
 *
 * @author Mulesoft Inc.
 * @since 2.3.0
 */
public class MunitDeployerLog implements org.mule.tools.utils.DeployerLog {

  private transient Logger logger = LoggerFactory.getLogger(this.getClass());
  private boolean debugEnabled;

  public MunitDeployerLog(boolean debugEnabled) {
    this.debugEnabled = debugEnabled;
  }

  @Override
  public void info(String s) {
    logger.info(s);
  }

  @Override
  public void error(String s) {
    logger.error(s);
  }

  @Override
  public void warn(String s) {
    logger.warn(s);
  }

  @Override
  public void debug(String s) {
    logger.debug(s);
  }

  @Override
  public void error(String s, Throwable throwable) {
    logger.error(s, throwable);
  }

  @Override
  public boolean isDebugEnabled() {
    return debugEnabled;
  }
}
