/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.remote.container.cloudhub.logging;

import org.mule.tools.client.cloudhub.CloudHubClient;
import org.mule.tools.client.cloudhub.model.Application;
import org.mule.tools.client.cloudhub.model.Deployment;
import org.mule.tools.utils.DeployerLog;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

/**
 * Task that gathers logs from CH
 * 
 * @since 2.3.0
 * @author Mulesoft Inc.
 */
public class CloudHubLoggingTask {

  private final DeployerLog deployerLog;
  private final CloudHubClient cloudHubClient;
  private final Application application;

  public CloudHubLoggingTask(DeployerLog deployerLog, CloudHubClient cloudHubClient,
                             Application application) {
    this.deployerLog = deployerLog;
    this.cloudHubClient = cloudHubClient;
    this.application = application;
  }

  public void log() {
    try {
      List<Deployment> deployments = cloudHubClient.getDeployments(application);
      getLastDeployment(deployments)
          .ifPresent(chDeployment -> {
            chDeployment.getInstances().stream().findFirst().ifPresent(instance -> {
              try (InputStream logs =
                  cloudHubClient.getEntireLogs(application, instance.getInstanceId())) {
                String readLine;
                BufferedReader br = new BufferedReader(new InputStreamReader(logs));
                while (((readLine = br.readLine()) != null)) {
                  System.out.println(readLine);
                }
              } catch (IOException e) {
                deployerLog.error("Unable to retrieve logs - " + e.getMessage());
              }
            });
          });
    } catch (Exception e) {
      deployerLog.error("Unable to retrieve logs - " + e.getMessage());
    }
  }

  private Optional<Deployment> getLastDeployment(List<Deployment> deployments) {
    return deployments.stream().max(Comparator.comparing(Deployment::getCreateTime));
  }
}
