/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.remote.api.configuration;

import static java.nio.charset.StandardCharsets.UTF_8;

import com.google.gson.Gson;
import org.apache.commons.cli.*;
import org.apache.commons.lang3.StringUtils;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;

/**
 * Takes a Command Line Arguments and generates a runConfiguration
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class RunConfigurationParser {

  public static final String RUN_CONFIGURATION_PARAMETER = "run_configuration";

  private static final int MIN_PORT_NUMBER = 50000;
  private static final int MAX_PORT_NUMBER = 55000;

  private Options options = new Options();
  private CommandLineParser parser = new BasicParser();

  public RunConfigurationParser() {
    options.addOption(createOption(RUN_CONFIGURATION_PARAMETER, true, "MUnit run configuration", true));
  }

  public RunConfiguration parse(String[] args) throws ParseException, IOException {
    CommandLine cmdLine = parser.parse(options, args);
    return buildRunConfiguration(cmdLine);
  }

  private RunConfiguration buildRunConfiguration(CommandLine cmd) throws IOException {
    String param = cmd.getOptionValue(RUN_CONFIGURATION_PARAMETER, StringUtils.EMPTY);

    Reader reader = new InputStreamReader(new FileInputStream(param), UTF_8);
    return new Gson().fromJson(reader, RunConfiguration.class);
  }

  private Option createOption(String name, String description) {
    return createOption(name, true, description, false);
  }

  private Option createOption(String name, boolean hasArg, String description, boolean required) {
    OptionBuilder.withDescription(description);
    OptionBuilder.hasArg(hasArg);
    OptionBuilder.isRequired(required);
    return OptionBuilder.create(name);
  }
}
