/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
/*
* Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
* copyright law. All use of this software is subject to MuleSoft's Master Subscription
* Agreement (or other master license agreement) separately entered into in writing between
* you and MuleSoft. If such an agreement is not in place, you may not use the software.
*/

package org.mule.munit.remote.api.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Defines the Container configuration for Embedded
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class EmbeddedContainerConfiguration extends ContainerConfiguration {

  private MavenConfiguration mavenConfiguration;
  private List<ServerPluginConfiguration> serverPluginConfigurations;

  protected EmbeddedContainerConfiguration(String runtimeId, String product, String munitWorkingDirectoryPath,
                                           String log4JConfigurationFilePath, MavenConfiguration mavenConfiguration,
                                           List<ServerPluginConfiguration> serverPluginConfigurations,
                                           Map<String, String> systemPropertyVariables,
                                           Map<String, String> environmentVariables) {
    super(DeploymentType.EMBEDDED.name(), runtimeId, product, munitWorkingDirectoryPath, log4JConfigurationFilePath,
          systemPropertyVariables, environmentVariables);
    this.mavenConfiguration = mavenConfiguration;
    this.serverPluginConfigurations = serverPluginConfigurations;
  }

  public MavenConfiguration getMavenConfiguration() {
    return mavenConfiguration;
  }

  public List<ServerPluginConfiguration> getServerPluginConfigurations() {
    return serverPluginConfigurations;
  }

  @Override
  public DeploymentType getType() {
    return DeploymentType.EMBEDDED;
  }

  /**
   * Embedded Container Configuration Builder
   *
   * @author Mulesoft Inc.
   * @since 2.0.0
   */
  public static class EmbeddedContainerConfigurationBuilder implements ContainerConfigurationBuilder {

    private String runtimeId;
    private String product;
    private String munitWorkingDirectoryPath;
    private String log4JConfigurationFilePath;
    private MavenConfiguration mavenConfiguration;
    private List<ServerPluginConfiguration> serverPluginConfigurations = new ArrayList<>();
    private Map<String, String> systemPropertyVariables;
    private Map<String, String> environmentVariables;

    public static EmbeddedContainerConfigurationBuilder from(EmbeddedContainerConfiguration cc) {
      EmbeddedContainerConfigurationBuilder builder = new EmbeddedContainerConfigurationBuilder();

      builder.withLog4JConfigurationFilePath(cc.getLog4JConfigurationFilePath());
      builder.withMavenConfiguration(cc.getMavenConfiguration());
      cc.getServerPluginConfigurations().forEach(spc -> builder.withServerPluginConfiguration(spc));
      builder.withProduct(cc.getProduct());
      builder.withRuntimeId(cc.getRuntimeId());
      builder.withMunitWorkingDirectoryPath(cc.getMunitWorkingDirectoryPath());
      return builder;
    }

    public EmbeddedContainerConfigurationBuilder withRuntimeId(String runtimeId) {
      this.runtimeId = runtimeId;
      return this;
    }

    public EmbeddedContainerConfigurationBuilder withProduct(String product) {
      this.product = product;
      return this;
    }

    public EmbeddedContainerConfigurationBuilder withMunitWorkingDirectoryPath(String munitWorkingDirectoryPath) {
      this.munitWorkingDirectoryPath = munitWorkingDirectoryPath;
      return this;
    }

    public EmbeddedContainerConfigurationBuilder withLog4JConfigurationFilePath(String log4JConfigurationFilePath) {
      this.log4JConfigurationFilePath = log4JConfigurationFilePath;
      return this;
    }

    public EmbeddedContainerConfigurationBuilder withMavenConfiguration(MavenConfiguration mavenConfiguration) {
      this.mavenConfiguration = mavenConfiguration;
      return this;
    }

    public EmbeddedContainerConfigurationBuilder withServerPluginConfiguration(ServerPluginConfiguration serverPluginConfiguration) {
      this.serverPluginConfigurations.add(serverPluginConfiguration);
      return this;
    }

    public EmbeddedContainerConfigurationBuilder withSystemPropertyVariables(Map<String, String> systemPropertyVariables) {
      this.systemPropertyVariables = systemPropertyVariables;
      return this;
    }

    public EmbeddedContainerConfigurationBuilder withEnvironmentVariables(Map<String, String> environmentVariables) {
      this.environmentVariables = environmentVariables;
      return this;
    }

    public EmbeddedContainerConfiguration build() {
      return new EmbeddedContainerConfiguration(runtimeId, product, munitWorkingDirectoryPath, log4JConfigurationFilePath,
                                                mavenConfiguration, serverPluginConfigurations, systemPropertyVariables,
                                                environmentVariables);
    }
  }

}
