/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.remote.api.configuration;

/**
 * This class defines the configuration of the debugger
 *
 * @author Mulesoft Inc.
 */
public class DebuggerConfiguration {

  private final Integer debuggerPort;
  private final String lockKey;

  public DebuggerConfiguration(Integer debuggerPort, String lockKey) {
    this.debuggerPort = debuggerPort;
    this.lockKey = lockKey;
  }

  public Integer getDebuggerPort() {
    return debuggerPort;
  }

  public String getLockKey() {
    return lockKey;
  }
}
