/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.remote.api.configuration;

import java.util.List;
import java.util.Set;
import org.mule.munit.remote.api.configuration.ContainerConfiguration;
import org.mule.munit.remote.api.configuration.CoverageConfiguration;
import org.mule.munit.remote.api.configuration.NotifierConfiguration;

public class RunConfiguration {
    private String runToken;
    private String projectName;
    private String domainLocation;
    private Set<String> tags;
    private Set<String> testNames;
    private Set<String> suitePaths;
    private Set<String> allSuitePaths;
    private Boolean skipAfterFailure;
    private List<NotifierConfiguration> notifierConfigurations;
    private CoverageConfiguration coverageConfiguration;
    private ContainerConfiguration containerConfiguration;

    protected RunConfiguration(String runToken, String domainLocation, String projectName, Set<String> tags, Set<String> testNames, Set<String> suitePaths, Set<String> allSuitePaths, Boolean skipAfterFailure, List<NotifierConfiguration> notifierConfigurations, CoverageConfiguration coverageConfiguration, ContainerConfiguration containerConfiguration) {
        this.runToken = runToken;
        this.domainLocation = domainLocation;
        this.projectName = projectName;
        this.tags = tags;
        this.testNames = testNames;
        this.suitePaths = suitePaths;
        this.allSuitePaths = allSuitePaths;
        this.skipAfterFailure = skipAfterFailure;
        this.notifierConfigurations = notifierConfigurations;
        this.coverageConfiguration = coverageConfiguration;
        this.containerConfiguration = containerConfiguration;
    }

    public String getRunToken() {
        return this.runToken;
    }

    public String getDomainLocation() {
        return this.domainLocation;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public Set<String> getTestNames() {
        return this.testNames;
    }

    public Set<String> getSuitePaths() {
        return this.suitePaths;
    }

    public Set<String> getAllSuitePaths() {
        return this.allSuitePaths;
    }

    public Boolean isSkipAfterFailure() {
        return this.skipAfterFailure;
    }

    public List<NotifierConfiguration> getNotifierConfigurations() {
        return this.notifierConfigurations;
    }

    public CoverageConfiguration getCoverageConfiguration() {
        return this.coverageConfiguration;
    }

    public ContainerConfiguration getContainerConfiguration() {
        return this.containerConfiguration;
    }

    public static class RunConfigurationBuilder {
        private String runToken;
        private String projectName;
        private String domainLocation;
        private Set<String> tags;
        private Set<String> testNames;
        private Set<String> suitePaths;
        private Set<String> allSuitePaths;
        private Boolean skipAfterFailure;
        private List<NotifierConfiguration> notifierConfigurations;
        private CoverageConfiguration coverageConfiguration;
        private ContainerConfiguration containerConfiguration;

        public static RunConfigurationBuilder from(RunConfiguration rc) {
            RunConfigurationBuilder builder = new RunConfigurationBuilder();
            builder.withRunToken(rc.getRunToken()).withDomainLocation(rc.getDomainLocation()).withProjectName(rc.getProjectName()).withTags(rc.getTags()).withTestNames(rc.getTestNames()).withSuitePaths(rc.getSuitePaths()).withAllSuitePaths(rc.getAllSuitePaths()).withSkipAfterFailure(rc.isSkipAfterFailure()).withNotifierConfigurations(rc.getNotifierConfigurations()).withCoverageConfiguration(rc.getCoverageConfiguration()).withContainerConfiguration(rc.getContainerConfiguration());
            return builder;
        }

        public RunConfigurationBuilder withRunToken(String runToken) {
            this.runToken = runToken;
            return this;
        }

        public RunConfigurationBuilder withDomainLocation(String domainLocation) {
            this.domainLocation = domainLocation;
            return this;
        }

        public RunConfigurationBuilder withProjectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public RunConfigurationBuilder withTags(Set<String> tags) {
            this.tags = tags;
            return this;
        }

        public RunConfigurationBuilder withTestNames(Set<String> testNames) {
            this.testNames = testNames;
            return this;
        }

        public RunConfigurationBuilder withSuitePaths(Set<String> suitePaths) {
            this.suitePaths = suitePaths;
            return this;
        }

        public RunConfigurationBuilder withAllSuitePaths(Set<String> allSuitePaths) {
            this.allSuitePaths = allSuitePaths;
            return this;
        }

        public RunConfigurationBuilder withSkipAfterFailure(Boolean skipAfterFailure) {
            this.skipAfterFailure = skipAfterFailure;
            return this;
        }

        public RunConfigurationBuilder withNotifierConfigurations(List<NotifierConfiguration> notifierConfigurations) {
            this.notifierConfigurations = notifierConfigurations;
            return this;
        }

        public RunConfigurationBuilder withCoverageConfiguration(CoverageConfiguration coverageConfiguration) {
            this.coverageConfiguration = coverageConfiguration;
            return this;
        }

        public RunConfigurationBuilder withContainerConfiguration(ContainerConfiguration containerConfiguration) {
            this.containerConfiguration = containerConfiguration;
            return this;
        }

        public RunConfiguration build() {
            return new RunConfiguration(this.runToken, this.domainLocation, this.projectName, this.tags, this.testNames, this.suitePaths, this.allSuitePaths, this.skipAfterFailure, this.notifierConfigurations, this.coverageConfiguration, this.containerConfiguration);
        }
    }
}

