/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.mock.tool;


import org.mule.munit.common.behavior.BehaviorManager;
import org.mule.munit.mock.behavior.DefaultBehaviorManager;
import org.mule.runtime.api.artifact.Registry;

import java.util.HashMap;
import java.util.Map;

/**
 * This is the general MUnit Tool
 *
 * @author Mulesoft Inc.
 * @since 1.0.0
 */
public abstract class AbstractMockingTool {

  protected Registry registry;

  protected String processorName;
  protected String processorNamespace = "mule";
  protected Map<String, Object> processorAttributes = new HashMap<>();

  public AbstractMockingTool(Registry registry) {
    this.registry = registry;
  }

  protected void checkValidQuery() {
    if (processorName == null) {
      throw new IllegalArgumentException("You must provide at least the processor name");
    }
  }

  protected DefaultBehaviorManager getManager() {
    return (DefaultBehaviorManager) registry.lookupByName(BehaviorManager.ID).get();
  }

  protected String getFullName() {
    return processorNamespace + ":" + processorName;
  }

}
