/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.mock.behavior;

import java.util.ArrayList;
import java.util.List;

import org.mule.munit.common.behavior.ProcessorCall;
import org.mule.munit.mock.tool.spy.SpyProcess;

/**
 * Represents a behavior to be executed before/after a processor call. This particular behavior is composed by other spy
 * processes.
 *
 * @author Mulesoft Inc.
 * @since 1.0.0
 */
public class SpyBehavior extends Behavior {

  /**
   * The spy processes to be executed for the call
   */
  private List<SpyProcess> spyProcesses = new ArrayList<>();

  public SpyBehavior(ProcessorCall processorCall, List<SpyProcess> spyProcesses) {
    super(processorCall);
    this.spyProcesses = spyProcesses;
  }

  public List<SpyProcess> getSpyProcesses() {
    return spyProcesses;
  }

  public void setSpyProcesses(List<SpyProcess> spyProcesses) {
    this.spyProcesses = spyProcesses;
  }

}
