/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mock.behavior;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.munit.common.behavior.ProcessorCall;
import org.mule.munit.common.exception.MunitError;
import org.mule.munit.common.model.EventAttributes;
import org.mule.munit.common.model.EventError;
import org.mule.munit.common.model.Payload;
import org.mule.munit.common.model.Variable;
import org.mule.munit.mock.behavior.Behavior;
import org.mule.runtime.api.component.execution.ComponentExecutionException;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.construct.Flow;

public class CallBehaviour
extends Behavior {
    private Flow flow;
    private org.mule.munit.common.model.Event input;

    public CallBehaviour(ProcessorCall processorCall, Flow flow) {
        super(processorCall);
        this.flow = flow;
    }

    public void evaluate(Event input) throws MunitError {
        if (!this.getEvent().isPresent()) {
            try {
                this.input = this.buildEvent(input);
                Event output = (Event)this.flow.execute(input).get();
                this.setEvent(this.buildEvent(output));
            }
            catch (ComponentExecutionException cause) {
                this.setEvent(this.buildEvent(cause.getEvent()));
            }
            catch (Throwable cause) {
                if (cause.getCause() instanceof ComponentExecutionException) {
                    this.setEvent(this.buildEvent(((ComponentExecutionException)cause.getCause()).getEvent()));
                }
                this.clearEvent();
                throw new MunitError(String.format("There was a problem while evaluating '%s'", this.flow.getName()), cause);
            }
        }
    }

    public void clearEvent() {
        this.setEvent(null);
        this.input = null;
    }

    public Optional<org.mule.munit.common.model.Event> getInput() {
        return Optional.ofNullable(this.input);
    }

    private org.mule.munit.common.model.Event buildEvent(Event event) {
        org.mule.munit.common.model.Event munitEvent = new org.mule.munit.common.model.Event();
        munitEvent.setPayload(this.buildPayload(event));
        munitEvent.setAttributes(this.buildAttributes(event));
        munitEvent.setError(this.buildError(event));
        munitEvent.setVariables(this.buildVariables(event));
        return munitEvent;
    }

    private Payload buildPayload(Event event) {
        TypedValue corePayload = event.getMessage().getPayload();
        MediaType coreMediaType = corePayload.getDataType().getMediaType();
        Payload munitPayload = new Payload();
        munitPayload.setValue(corePayload.getValue());
        munitPayload.setMediaType(coreMediaType.withoutParameters().toString());
        coreMediaType.getCharset().ifPresent(charset -> munitPayload.setEncoding(charset.toString()));
        return munitPayload;
    }

    private EventAttributes buildAttributes(Event event) {
        TypedValue coreAttributes = event.getMessage().getAttributes();
        if (coreAttributes != null) {
            EventAttributes munitAttributes = new EventAttributes();
            MediaType coreMediaType = coreAttributes.getDataType().getMediaType();
            munitAttributes.setValue(coreAttributes.getValue());
            munitAttributes.setMediaType(coreMediaType.withoutParameters().toString());
            coreMediaType.getCharset().ifPresent(charset -> munitAttributes.setEncoding(charset.toString()));
            return munitAttributes;
        }
        return null;
    }

    private EventError buildError(Event event) {
        if (event.getError().isPresent()) {
            EventError munitError = new EventError();
            munitError.setCause((Object)((Error)event.getError().get()).getCause());
            munitError.setTypeId(((Error)event.getError().get()).getErrorType().getIdentifier());
            return munitError;
        }
        return null;
    }

    private List<Variable> buildVariables(Event event) {
        Map coreEventVariables = event.getVariables();
        ArrayList<Variable> munitVariables = new ArrayList<Variable>();
        for (String key : coreEventVariables.keySet()) {
            Variable munitVariable = new Variable();
            munitVariable.setKey(key);
            munitVariable.setValue(((TypedValue)coreEventVariables.get(key)).getValue());
            ((TypedValue)coreEventVariables.get(key)).getDataType().getMediaType().getCharset().ifPresent(charset -> munitVariable.setEncoding(charset.toString()));
            MediaType mimeType = ((TypedValue)coreEventVariables.get(key)).getDataType().getMediaType();
            if (!mimeType.equals((Object)MediaType.ANY)) {
                munitVariable.setMediaType(mimeType.withoutParameters().toString());
            }
            munitVariables.add(munitVariable);
        }
        return munitVariables;
    }
}

