/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.mock.interception;

import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;
import org.mule.munit.common.event.DataTypeBuilder;
import org.mule.munit.common.event.MessageBuilderDecorator;
import org.mule.munit.common.model.Event;
import org.mule.munit.common.model.EventAttributes;
import org.mule.munit.common.model.NullObject;
import org.mule.munit.common.model.Payload;
import org.mule.munit.common.model.TypedKeyValue;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.DataTypeParamsBuilder;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.privileged.interception.InternalInterceptionEvent;

public class InterceptingEventBuilder {
    public InterceptionEvent build(InterceptionEvent originalEvent, Event mockedEvent) {
        this.setVariables(originalEvent, mockedEvent);
        this.setSessionProperties((InternalInterceptionEvent)originalEvent, mockedEvent);
        originalEvent.message(this.buildMessage(originalEvent.getMessage(), mockedEvent));
        return originalEvent;
    }

    private void setVariables(InterceptionEvent originalEvent, Event mockedEvent) {
        if (null != mockedEvent.getVariables()) {
            mockedEvent.getVariables().forEach(v -> originalEvent.addVariable(v.getKey(), (Object)v.getValue(), DataTypeBuilder.fromTypedKeyValue((TypedKeyValue)v).build()));
        }
    }

    private void setSessionProperties(InternalInterceptionEvent originalEvent, Event mockedEvent) {
        if (null != mockedEvent.getSessionProperties()) {
            mockedEvent.getSessionProperties().forEach(p -> originalEvent.getSession().setProperty(p.getKey(), p.getValue(), DataTypeBuilder.fromTypedKeyValue((TypedKeyValue)p).build()));
        }
    }

    private Message buildMessage(Message originalMessage, Event mockedEvent) {
        MessageBuilderDecorator builder = new MessageBuilderDecorator(originalMessage);
        Payload mockedEventPayload = mockedEvent.getPayload();
        if (!(mockedEventPayload.getValue() instanceof NullObject)) {
            builder.withPayload(mockedEventPayload.getValue());
        }
        if (mockedEventPayload.getMediaType() != null) {
            MediaType mediaType = MediaType.parse((String)mockedEventPayload.getMediaType());
            if (mockedEventPayload.getEncoding() != null) {
                mediaType = mediaType.withCharset(Charset.forName(mockedEventPayload.getEncoding()));
            }
            builder.withMediaType(mediaType);
        }
        if (mockedEvent.getAttributes() != null && !(mockedEvent.getAttributes().getValue() instanceof NullObject)) {
            EventAttributes e = mockedEvent.getAttributes();
            DataTypeParamsBuilder dataTypeParamsBuilder = DataType.builder().fromObject(e.getValue());
            if (StringUtils.isNotBlank((CharSequence)e.getMediaType())) {
                dataTypeParamsBuilder.mediaType(e.getMediaType());
            }
            DataType dataType = dataTypeParamsBuilder.charset(e.getEncoding()).build();
            TypedValue typedValueAttributes = new TypedValue(e.getValue(), dataType);
            builder.withAttributes(typedValueAttributes);
        }
        if (null != mockedEvent.getInboundProperties()) {
            mockedEvent.getInboundProperties().forEach(p -> builder.withInboundProperty(p.getKey(), (Object)p.getValue(), p.getMediaType(), p.getEncoding()));
        }
        if (null != mockedEvent.getOutboundProperties()) {
            mockedEvent.getOutboundProperties().forEach(p -> builder.withOutboundProperty(p.getKey(), (Object)p.getValue(), p.getMediaType(), p.getEncoding()));
        }
        if (null != mockedEvent.getInboundAttachments()) {
            mockedEvent.getInboundAttachments().forEach(a -> builder.withInboundAttachment(a.getKey(), a.getDataHandler()));
        }
        if (null != mockedEvent.getOutboundAttachments()) {
            mockedEvent.getOutboundAttachments().forEach(a -> builder.withOutboundAttachment(a.getKey(), a.getDataHandler()));
        }
        return builder.build();
    }
}

