/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugin.maven.util;

import com.mulesoft.anypoint.discovery.api.RuntimeVersionProvider;
import com.mulesoft.anypoint.discovery.api.exception.NoLatestVersionFoundException;
import com.mulesoft.anypoint.discovery.api.exception.VersionDiscoveryException;
import com.mulesoft.anypoint.discovery.api.version.ArtifactVersionFactory;
import com.mulesoft.anypoint.discovery.api.version.ArtifactVersionValidator;
import com.mulesoft.anypoint.discovery.core.aether.AetherRuntimeVersionProvider;
import com.mulesoft.anypoint.discovery.core.version.MuleArtifactVersionFactory;
import com.mulesoft.anypoint.discovery.core.version.MuleArtifactVersionValidator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.version.Version;
import org.mule.munit.plugin.maven.locators.RemoteRepositoriesLocator;
import org.mule.runtime.api.deployment.meta.Product;

public class RuntimeVersionProviderFactory {
    private final Log log;
    private final RepositorySystem repositorySystem;
    private final RepositorySystemSession repositorySystemSession;
    private final RemoteRepositoriesLocator remoteRepositoriesLocator;

    public RuntimeVersionProviderFactory(RepositorySystem repositorySystem, RepositorySystemSession repositorySystemSession, RemoteRepositoriesLocator remoteRepositoriesLocator, Log log) {
        this.repositorySystem = repositorySystem;
        this.repositorySystemSession = repositorySystemSession;
        this.remoteRepositoriesLocator = remoteRepositoriesLocator;
        this.log = log;
    }

    public Optional<RuntimeVersionProvider> create(Product product) throws MojoExecutionException {
        List<RemoteRepository> remoteRepositories = this.remoteRepositoriesLocator.locate();
        try {
            this.validateRepositories(remoteRepositories);
            return Optional.of(new AetherRuntimeVersionProvider(this.repositorySystem, this.repositorySystemSession, remoteRepositories, this.getProduct(product), (ArtifactVersionFactory)new MuleArtifactVersionFactory(), (ArtifactVersionValidator)new MuleArtifactVersionValidator()));
        }
        catch (VersionDiscoveryException e) {
            throw new MojoExecutionException("An error occurred while discovering versions for product " + product + " in the following repositories " + remoteRepositories);
        }
        catch (NoLatestVersionFoundException e) {
            this.log.warn((CharSequence)("Unable to find Mule Runtime versions for product " + product));
            return Optional.empty();
        }
    }

    public List<Version> muleFrameworkVersions() throws MojoExecutionException {
        return this.muleFrameworkVersionsRange().getVersions();
    }

    public Optional<Version> muleFrameworkLatestVersion() throws MojoExecutionException {
        return Optional.ofNullable(this.muleFrameworkVersionsRange().getHighestVersion());
    }

    private VersionRangeResult muleFrameworkVersionsRange() throws MojoExecutionException {
        VersionRangeResult versionRange;
        List<RemoteRepository> remoteRepositories = this.remoteRepositoriesLocator.locate();
        VersionRangeRequest rangeRequest = new VersionRangeRequest((Artifact)new DefaultArtifact("org.mule.fwk:mule-framework-bom:(0,]"), remoteRepositories, null);
        try {
            versionRange = this.repositorySystem.resolveVersionRange(this.repositorySystemSession, rangeRequest);
        }
        catch (VersionRangeResolutionException e) {
            throw new MojoExecutionException("An error occurred while discovering versions for MuleFramework in the following repositories " + remoteRepositories);
        }
        return versionRange;
    }

    private com.mulesoft.anypoint.discovery.core.aether.Product getProduct(Product product) {
        switch (product) {
            case MULE_EE: {
                return com.mulesoft.anypoint.discovery.core.aether.Product.EE_BOM;
            }
            case MULE: {
                return com.mulesoft.anypoint.discovery.core.aether.Product.CE_BOM;
            }
        }
        throw new IllegalArgumentException("Unsupported product to discover runtimes: " + product);
    }

    private void validateRepositories(List<RemoteRepository> remoteRepositories) throws MojoExecutionException {
        if (remoteRepositories.isEmpty()) {
            throw new MojoExecutionException(String.format("%nNo repositories found to discover runtimes.%nFound:%n  %s%nbut needed one of:%n  %s%n", this.remoteRepositoriesLocator.locateAll().stream().map(RemoteRepository::getUrl).collect(Collectors.joining(String.format(",%n  ", new Object[0]))), String.join((CharSequence)String.format(",%n  ", new Object[0]), this.remoteRepositoriesLocator.getWhitelistedRepositories())));
        }
    }
}

