/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugin.maven.fips;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;

public class FipsArgumentsResolver {
    private static final String JAVA_SECURITY_PROPERTIES_FILE_PROPERTY = "java.security.properties";
    private static final String FIPS_SECURITY_PROPERTIES = "security.provider.1=org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider\nsecurity.provider.2=org.bouncycastle.jsse.provider.BouncyCastleJsseProvider fips:BCFIPS\nsecurity.provider.3=sun.security.provider.Sun\nsecurity.provider.4=sun.security.rsa.SunRsaSign\nsecurity.provider.5=sun.security.ec.SunEC\nsecurity.provider.6=com.sun.net.ssl.internal.ssl.Provider BCFIPS\nsecurity.provider.7=com.sun.crypto.provider.SunJCE\nsecurity.provider.8=sun.security.jgss.SunProvider\nsecurity.provider.9=com.sun.security.sasl.Provider\nsecurity.provider.10=org.jcp.xml.dsig.internal.dom.XMLDSigRI\nsecurity.provider.11=sun.security.smartcardio.SunPCSC\nsecurity.provider.12=apple.security.AppleProvider\nssl.KeyManagerFactory.algorithm=PKIX\nssl.TrustManagerFactory.algorithm=PKIX\nkeystore.type=PKCS12";
    private static final String FIPS_SECURITY_PROPERTIES_140_3 = "security.provider.1=org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider\nsecurity.provider.2=org.bouncycastle.jsse.provider.BouncyCastleJsseProvider fips:BCFIPS\nsecurity.provider.3=SUN\nssl.KeyManagerFactory.algorithm=PKIX\nssl.TrustManagerFactory.algorithm=PKIX\nkeystore.type=bcfks";
    private final Log log;
    private final RepositorySystem repositorySystem;
    private final RepositorySystemSession repositorySystemSession;
    private final List<RemoteRepository> remoteRepositories;
    private final File fipsSecurityPropertiesFile;
    private final List<Dependency> additionalFipsDependencies;
    private List<String> resolvedClassPathEntriesForAdditionalFipsDependencies;
    public static final String FIPS_140_2 = "140-2";
    public static final String FIPS_140_3 = "140-3";
    public String fipsType;

    public FipsArgumentsResolver(Log log, RepositorySystem repositorySystem, RepositorySystemSession repositorySystemSession, List<RemoteRepository> remoteRepositories, List<Dependency> additionalFipsDependencies, String securityPropertiesFilePath, String fipsType) throws IOException {
        this.log = log;
        this.repositorySystem = repositorySystem;
        this.repositorySystemSession = repositorySystemSession;
        this.remoteRepositories = remoteRepositories;
        this.additionalFipsDependencies = additionalFipsDependencies;
        this.fipsType = fipsType;
        this.fipsSecurityPropertiesFile = securityPropertiesFilePath != null ? new File(securityPropertiesFilePath) : this.createSecurePropertiesFile(fipsType);
    }

    public List<String> getClassPathEntriesForFipsProviders() throws MojoExecutionException {
        if (this.resolvedClassPathEntriesForAdditionalFipsDependencies == null) {
            this.resolvedClassPathEntriesForAdditionalFipsDependencies = this.doGetClassPathEntriesForFipsProviders();
        }
        return this.resolvedClassPathEntriesForAdditionalFipsDependencies;
    }

    public String getSecurePropertiesArgument() {
        return "-Djava.security.properties=" + this.fipsSecurityPropertiesFile.getAbsolutePath();
    }

    private List<String> doGetClassPathEntriesForFipsProviders() throws MojoExecutionException {
        if (this.additionalFipsDependencies == null) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Dependency additionalFipsDependency : this.additionalFipsDependencies) {
            String s = this.resolveDependencyToPath(additionalFipsDependency);
            list.add(s);
        }
        return list;
    }

    private File createSecurePropertiesFile(String fipsType) throws IOException {
        File fipsSecurityPropertiesFile = File.createTempFile("tmp", "fips.security.properties");
        fipsSecurityPropertiesFile.deleteOnExit();
        FileUtils.writeStringToFile((File)fipsSecurityPropertiesFile, (String)(fipsType != null && fipsType.equals(FIPS_140_3) ? FIPS_SECURITY_PROPERTIES_140_3 : FIPS_SECURITY_PROPERTIES), (Charset)Charset.defaultCharset());
        return fipsSecurityPropertiesFile;
    }

    private String resolveDependencyToPath(Dependency dependency) throws MojoExecutionException {
        ArtifactResult result;
        DefaultArtifact artifact;
        try {
            artifact = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), dependency.getType(), dependency.getVersion());
        }
        catch (IllegalArgumentException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        ArtifactRequest request = new ArtifactRequest((Artifact)artifact, this.remoteRepositories, null);
        this.log.info((CharSequence)String.format("Resolving artifact %s from %s", artifact, this.remoteRepositories));
        try {
            result = this.repositorySystem.resolveArtifact(this.repositorySystemSession, request);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        this.log.info((CharSequence)String.format("Resolved artifact %s to %s from %s", artifact, result.getArtifact().getFile(), result.getRepository()));
        return result.getArtifact().getFile().getPath();
    }
}

