/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugin.maven.locators;

import com.mulesoft.anypoint.discovery.api.RuntimeVersionProvider;
import com.mulesoft.anypoint.discovery.api.version.ArtifactVersion;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.aether.version.Version;
import org.mule.munit.plugin.maven.runtime.Product;
import org.mule.munit.plugin.maven.runtime.TargetProduct;
import org.mule.munit.plugin.maven.util.RuntimeVersionProviderFactory;
import org.mule.runtime.api.meta.MuleVersion;

public class ProductVersionsLocator {
    private final RuntimeVersionProviderFactory runtimeVersionProviderFactory;
    private Product product;
    private String minVersion;
    private boolean includeSnapshots;
    private final Log log;
    private boolean useLatestPatches;

    public ProductVersionsLocator(RuntimeVersionProviderFactory runtimeVersionProviderFactory, Log log) {
        this.runtimeVersionProviderFactory = runtimeVersionProviderFactory;
        this.log = log;
    }

    public ProductVersionsLocator withMinVersion(String minVersion) {
        this.minVersion = minVersion;
        return this;
    }

    public ProductVersionsLocator withProduct(Product product) {
        this.product = product;
        return this;
    }

    public ProductVersionsLocator includingSnapshots(boolean includeSnapshots) {
        this.includeSnapshots = includeSnapshots;
        return this;
    }

    public ProductVersionsLocator usingLatestPatches(boolean useLatestPatches) {
        this.useLatestPatches = useLatestPatches;
        return this;
    }

    public Set<TargetProduct> locate() throws MojoExecutionException {
        Stream<TargetProduct> targetRuntimes = Stream.empty();
        if (this.product.equals((Object)Product.MULE_CE) || this.product.equals((Object)Product.MULE_EE)) {
            List<ArtifactVersion> eeRuntimeVersions = this.product.supportsEe() ? this.locateRuntimes(this.runtimeVersionProviderFactory, org.mule.runtime.api.deployment.meta.Product.MULE_EE) : Collections.emptyList();
            List<ArtifactVersion> ceRuntimeVersions = this.product.supportsCe() ? this.locateRuntimes(this.runtimeVersionProviderFactory, org.mule.runtime.api.deployment.meta.Product.MULE) : Collections.emptyList();
            targetRuntimes = this.createTargetProducts(eeRuntimeVersions, ceRuntimeVersions, Collections.emptyList());
        } else if (this.product.equals((Object)Product.MULE_FWK)) {
            List<Version> muleFwkVersions = this.runtimeVersionProviderFactory.muleFrameworkVersions();
            targetRuntimes = this.createTargetProducts(Collections.emptyList(), Collections.emptyList(), muleFwkVersions);
        }
        targetRuntimes = targetRuntimes.filter(this::isNotCePatchVersion).filter(this::includeSnapshots).filter(this::greaterThanMinVersion);
        if (this.useLatestPatches) {
            targetRuntimes = this.filterLatestPatches(targetRuntimes);
        }
        this.log.debug((CharSequence)("Discovered Products: " + targetRuntimes));
        return targetRuntimes.collect(Collectors.toCollection(TreeSet::new));
    }

    private boolean isNotCePatchVersion(TargetProduct targetProduct) {
        if (targetProduct.getProduct() == Product.MULE_CE) {
            MuleVersion muleVersion = new MuleVersion(targetProduct.getVersion());
            return muleVersion.getRevision() == 0 || muleVersion.equals((Object)this.product.getMinVersion());
        }
        return true;
    }

    private Stream<TargetProduct> createTargetProducts(List<ArtifactVersion> eeVersions, List<ArtifactVersion> ceVersions, List<Version> muleFwkVersions) {
        Stream<TargetProduct> ceRuntimes = ceVersions.stream().map(version -> this.toTargetProduct((ArtifactVersion)version, org.mule.runtime.api.deployment.meta.Product.MULE));
        Stream<TargetProduct> eeRuntimes = eeVersions.stream().map(version -> this.toTargetProduct((ArtifactVersion)version, org.mule.runtime.api.deployment.meta.Product.MULE_EE));
        Stream<TargetProduct> muleFrameworks = muleFwkVersions.stream().map(version -> new TargetProduct(version.toString(), Product.MULE_FWK));
        return Stream.concat(Stream.concat(ceRuntimes, eeRuntimes), muleFrameworks);
    }

    private List<ArtifactVersion> locateRuntimes(RuntimeVersionProviderFactory versionProviderFactory, org.mule.runtime.api.deployment.meta.Product product) throws MojoExecutionException {
        return versionProviderFactory.create(product).map(RuntimeVersionProvider::all).orElse(Collections.emptyList());
    }

    private boolean greaterThanMinVersion(TargetProduct targetRuntime) {
        return new MuleVersion(targetRuntime.getVersion()).atLeast(this.minVersion);
    }

    private boolean includeSnapshots(TargetProduct targetRuntime) {
        MuleVersion muleVersion = new MuleVersion(targetRuntime.getVersion());
        if (muleVersion.hasSuffix()) {
            return this.includeSnapshots && "SNAPSHOT".equals(muleVersion.getSuffix());
        }
        return true;
    }

    private TargetProduct toTargetProduct(ArtifactVersion artifactVersion, org.mule.runtime.api.deployment.meta.Product product) {
        return new TargetProduct(artifactVersion.value(), product == org.mule.runtime.api.deployment.meta.Product.MULE ? Product.MULE_CE : Product.valueOf(product.name()));
    }

    private Stream<TargetProduct> filterLatestPatches(Stream<TargetProduct> targetRuntimes) {
        HashMap latestPatches = new HashMap();
        targetRuntimes.forEach(targetRuntime -> {
            MuleVersion version = new MuleVersion(targetRuntime.getVersion());
            String versionKey = String.format("%d.%d%s", version.getMajor(), version.getMinor(), version.getSuffix());
            if (latestPatches.containsKey(versionKey)) {
                TargetProduct currentLatest = (TargetProduct)latestPatches.get(versionKey);
                if (version.newerThan(currentLatest.getVersion())) {
                    latestPatches.put(versionKey, targetRuntime);
                }
            } else {
                latestPatches.put(versionKey, targetRuntime);
            }
        });
        return latestPatches.values().stream();
    }
}

