/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.plugin.maven.runner.model;

/**
 * <p>
 * A model that represents the result of a test run
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class TestResult {

  private String testName;
  private boolean ignored;
  private boolean failed;
  private boolean error;
  private boolean finished;
  private long time;
  private String cause;

  public TestResult(String testName) {
    this.testName = testName;
  }

  public String getTestName() {
    return testName;
  }

  public boolean isIgnored() {
    return ignored;
  }

  public void setIgnored(boolean ignored) {
    this.ignored = ignored;
  }

  public void setFailed(boolean failed) {
    this.failed = failed;
  }

  public void setError(boolean error) {
    this.error = error;
  }

  public boolean hasError() {
    return error;
  }

  public boolean hasFailed() {
    return failed;
  }

  public boolean isFinished() {
    return finished || failed || error;
  }

  public void setFinished(boolean finished) {
    this.finished = finished;
  }

  public String getCause() {
    return cause;
  }

  public void setCause(String cause) {
    this.cause = cause;
  }

  public void setTime(long time) {
    this.time = time;
  }

  public long getTime() {
    return time;
  }

}
