/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.plugin.maven.report.xml.sonar;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * Model to represent the test executions in the xml Sonar report
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.3.0
 */
@XStreamAlias(value = "testExecutions")
public class SonarTestExecutions {

  @XStreamAsAttribute
  private final int version = 1;

  @XStreamImplicit
  private List<SonarFile> file = new ArrayList<>();

  public void add(SonarFile sonarFile) {
    file.add(sonarFile);
  }

  public List<SonarFile> getFiles() {
    return file;
  }
}
