/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.plugin.maven.report.xml.sonar;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;

/**
 * <p>
 * Model to represent the test case in the xml Sonar report
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.3.0
 */
@XStreamAlias(value = "testCase")
public class SonarTestCase {

  @XStreamAsAttribute
  private String name;

  @XStreamAsAttribute
  private long duration;

  private SonarFailure failure;
  private SonarError error;
  private SonarSkipped skipped;

  public SonarTestCase(long duration, String name) {
    this.duration = duration;
    this.name = name;
  }

  public void setFailure(String cause) {
    this.failure = new SonarFailure(cause);
  }

  public void setError(String cause) {
    this.error = new SonarError(cause);
  }

  public void setSkipped(String cause) {
    this.skipped = new SonarSkipped(cause);
  }

  public SonarFailure getFailure() {
    return failure;
  }

  public SonarError getError() {
    return error;
  }

  public SonarSkipped getSkipped() {
    return skipped;
  }
}
