/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.plugin.maven.report.xml.sonar;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import com.thoughtworks.xstream.converters.extended.ToAttributedValueConverter;

/**
 * <p>
 * Model to represent the test error in the xml Sonar report
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.3.0
 */
@XStreamAlias(value = "error")
@XStreamConverter(value = ToAttributedValueConverter.class, strings = {"value"})
public class SonarError {

  public SonarError(String message) {
    this.value = message;
  }

  @XStreamAsAttribute
  private String message = "long";

  protected String value;

  public String getValue() {
    return value;
  }
}
