/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugin.maven.util;

import java.io.File;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.mule.munit.plugin.maven.runner.structure.WorkingDirectoryGenerator;
import org.mule.munit.plugin.maven.runtime.TargetProduct;
import org.mule.munit.plugin.maven.util.BaseRunConfigurationFactory;
import org.mule.munit.remote.api.configuration.CloudHubContainerConfiguration;
import org.mule.munit.remote.api.configuration.ContainerConfiguration;
import org.mule.tools.model.Deployment;
import org.mule.tools.model.anypoint.CloudHubDeployment;

public class BaseCloudHubRunConfigurationFactory
extends BaseRunConfigurationFactory {
    private final CloudHubDeployment deployment;
    private final Map<String, String> systemPropertyVariables;
    private final Map<String, String> environmentVariables;
    private final boolean debugEnabled;
    private final String executionId;

    public BaseCloudHubRunConfigurationFactory(Log log, String projectName, String munitTest, String munitTags, Boolean skipAfterFailure, TargetProduct targetProduct, WorkingDirectoryGenerator workingDirectoryGenerator, File munitSrcFolder, MavenProject project, MavenSession session, Deployment deployment, Map<String, String> systemPropertyVariables, Map<String, String> environmentVariables, String executionId, Boolean clearParameters) {
        super(log, projectName, munitTest, munitTags, skipAfterFailure, targetProduct, workingDirectoryGenerator, munitSrcFolder, project, session, clearParameters);
        this.deployment = (CloudHubDeployment)deployment;
        this.systemPropertyVariables = systemPropertyVariables;
        this.environmentVariables = environmentVariables;
        this.debugEnabled = log.isDebugEnabled();
        this.executionId = executionId;
    }

    @Override
    protected ContainerConfiguration.ContainerConfigurationBuilder getContainerConfigurationBuilder() {
        return new CloudHubContainerConfiguration.CloudHubContainerConfigurationBuilder().withDeploymentConfiguration((Deployment)this.deployment).withMunitWorkingDirectoryPath(this.getWorkingDirectoryGenerator().generateWorkingDirectory().toFile().getAbsolutePath()).withLog4JConfigurationFilePath(this.getLog4JConfigurationFilePath()).withExecutionId(this.executionId).withSystemPropertyVariables(this.systemPropertyVariables).withEnvironmentVariables(this.environmentVariables).withDebugEnabled(this.debugEnabled);
    }
}

