/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugin.maven.runner;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.utils.cli.CommandLineException;
import org.apache.maven.shared.utils.cli.CommandLineUtils;
import org.apache.maven.shared.utils.cli.Commandline;
import org.apache.maven.shared.utils.cli.StreamConsumer;
import org.mule.munit.plugin.maven.runner.outputStreamString;

public class JVMStarter {
    private Log log;
    protected Commandline commandline = new Commandline();
    protected Commandline commandlineVersion = new Commandline();

    public JVMStarter(Log log) throws IOException {
        this.log = log;
    }

    public JVMStarter withJVM(String jvm) {
        this.commandline.setExecutable(jvm);
        this.commandlineVersion.setExecutable(jvm);
        return this;
    }

    public JVMStarter withJar(File jarFile) {
        this.commandline.createArg().setValue("-jar");
        this.commandline.createArg().setFile(jarFile);
        return this;
    }

    public JVMStarter withWorkingDirectory(File workingDirectory) {
        this.commandline.setWorkingDirectory(workingDirectory);
        this.commandlineVersion.setWorkingDirectory(workingDirectory);
        return this;
    }

    public JVMStarter withArgLines(List<String> argLines) {
        for (String argLine : argLines) {
            this.commandline.createArg(true).setValue(argLine);
        }
        return this;
    }

    public JVMStarter withArgLines(Map<String, File> argLines) {
        for (Map.Entry<String, File> argLine : argLines.entrySet()) {
            this.commandline.createArg().setValue(argLine.getKey());
            this.commandline.createArg().setFile(argLine.getValue());
        }
        return this;
    }

    public JVMStarter withSystemProperties(Map<String, String> systemProperties) {
        for (Map.Entry<String, String> prop : systemProperties.entrySet()) {
            this.commandline.createArg(true).setValue("-D" + prop.getKey() + "=" + prop.getValue());
        }
        return this;
    }

    public JVMStarter addEnvironmentVariables(Map<String, String> environmentVariables) {
        for (Map.Entry<String, String> envVar : environmentVariables.entrySet()) {
            this.commandline.addEnvironment(envVar.getKey(), envVar.getValue());
        }
        return this;
    }

    public int execute(StreamConsumer outStreamConsumer, StreamConsumer errStreamConsumer) throws CommandLineException {
        this.log.debug((CharSequence)("Executing command line: " + this.commandline));
        return CommandLineUtils.executeCommandLine((Commandline)this.commandline, (StreamConsumer)outStreamConsumer, (StreamConsumer)errStreamConsumer);
    }

    public String getVersion() {
        outputStreamString outStream = new outputStreamString();
        outputStreamString outStreamError = new outputStreamString();
        try {
            this.commandlineVersion.addArguments(new String[]{"-version"});
            CommandLineUtils.executeCommandLine((Commandline)this.commandlineVersion, (StreamConsumer)outStream, (StreamConsumer)outStreamError);
        }
        catch (CommandLineException e) {
            throw new RuntimeException(e);
        }
        String output = outStream.getOutput().equals("") ? outStreamError.getOutput() : outStream.getOutput();
        return StringUtils.substringBetween((String)output, (String)"\"", (String)"\"");
    }
}

