/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.plugin.maven.runner.printer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;
import org.mule.munit.plugin.maven.runner.model.RunResult;
import org.mule.munit.plugin.maven.runner.model.SuiteResult;
import org.mule.munit.plugin.maven.runner.model.TestResult;
import org.mule.munit.plugin.maven.runner.printer.FileResultPrinter;
import org.mule.munit.plugin.maven.runtime.TargetRuntime;

public class TextResultFilePrinter
extends FileResultPrinter {
    private static final float MILLIS_FACTOR = 1000.0f;
    private static final String SUITE_RESULT_MESSAGE = "Tests run: %d - Failures: %d - Errors: %d - Skipped: %d - Time elapsed: %.3f sec";
    private static final String TEST_ERROR_MESSAGE = "ERROR - Test %s finished with an Error.\n";
    private static final String TEST_FAILED_MESSAGE = "FAILURE - Test %s finished with a Failure.\n";
    private static final String TEST_IGNORED_MESSAGE = "SKIPPED - Test %s was Skipped.\n";
    private static final String TEST_SUCCESS_MESSAGE = "SUCCESS - Test %s finished Successfully.\n";
    private static final String TXT_REPORT_HEADER = "munit";

    public TextResultFilePrinter(File reportBasePath, Log log) {
        super(reportBasePath, log);
    }

    @Override
    public void print(TargetRuntime targetRuntime, RunResult runResult) {
        try {
            for (SuiteResult suiteResult : runResult.getSuites()) {
                this.printSuiteResult(targetRuntime, suiteResult);
            }
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void printSuiteResult(TargetRuntime targetRuntime, SuiteResult result) throws FileNotFoundException, UnsupportedEncodingException {
        String suiteRelativePath = result.getSuitePath();
        String suiteReportName = suiteRelativePath.replace("/", ".");
        suiteReportName = suiteReportName.replace(".xml", "");
        suiteReportName = suiteReportName + result.getParameterization().map(parameterization -> "[" + parameterization + "]").orElse("");
        suiteReportName = suiteReportName + ".txt";
        PrintStream out = this.getResultPrintStream(String.format("%s.%s.%s.%s", TXT_REPORT_HEADER, targetRuntime.getRuntimeProduct(), targetRuntime.getRuntimeVersion(), suiteReportName));
        for (TestResult testResult : result.getTests()) {
            this.printTestResult(testResult, out);
        }
        out.println();
        if (result.hasError() || result.hasFailed()) {
            out.println(result.getCause());
        }
        String title = String.format(SUITE_RESULT_MESSAGE, result.getNumberOfTests(), result.getNumberOfFailures(), result.getNumberOfErrors(), result.getNumberOfIgnores(), Float.valueOf((float)result.getTime() / 1000.0f));
        String titleFrame = StringUtils.repeat((String)"=", (int)title.length());
        out.println(titleFrame);
        out.println(title);
        out.println(titleFrame);
        out.flush();
    }

    public void printTestResult(TestResult testResult, PrintStream out) {
        if (testResult.hasError()) {
            out.format(TEST_ERROR_MESSAGE, testResult.getTestName());
            out.println(testResult.getCause());
        } else if (testResult.hasFailed()) {
            out.format(TEST_FAILED_MESSAGE, testResult.getTestName());
            out.println(testResult.getCause());
        } else if (testResult.isIgnored()) {
            out.format(TEST_IGNORED_MESSAGE, testResult.getTestName());
        } else {
            out.format(TEST_SUCCESS_MESSAGE, testResult.getTestName());
        }
        out.flush();
    }
}

