/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.extension.maven.internal.generator;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.mule.maven.client.api.MavenReactorResolver;
import org.mule.maven.client.api.model.BundleDescriptor;

public class ExtensionMavenReactorResolver
implements MavenReactorResolver {
    protected static final String MULE_PLUGIN_CLASSIFIER = "mule-plugin";
    private static final String POM = "pom";
    private final MavenProject project;

    public ExtensionMavenReactorResolver(MavenProject project) {
        this.project = project;
    }

    public File findArtifact(BundleDescriptor bundleDescriptor) {
        if (this.isExtensionProject(bundleDescriptor)) {
            if (bundleDescriptor.getType().equals(POM)) {
                return this.project.getFile();
            }
            String buildDir = this.project.getBuild().getDirectory();
            return new File(buildDir + "/" + this.project.getArtifactId() + "-" + this.project.getVersion() + "-" + MULE_PLUGIN_CLASSIFIER + ".jar");
        }
        return null;
    }

    public List<String> findVersions(BundleDescriptor bundleDescriptor) {
        if (this.isExtensionProject(bundleDescriptor)) {
            return ImmutableList.of((Object)this.project.getVersion());
        }
        return Collections.emptyList();
    }

    private boolean isExtensionProject(BundleDescriptor bundleDescriptor) {
        return this.project.getGroupId().equals(bundleDescriptor.getGroupId()) && this.project.getArtifactId().equals(bundleDescriptor.getArtifactId()) && this.project.getVersion().equals(bundleDescriptor.getVersion());
    }
}

