/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.behavior;

/**
 * The representation of a Processor Id
 *
 * @author Mulesoft Inc.
 * @since 1.0.0
 */
public class ProcessorId {

  private static final String COLON = ":";
  private static final String DEFAULT_NAMESPACE = "mule";

  /**
   * The Name of the processor. For example, the name of mule:set-payload is set-payload
   */
  private String name;

  /**
   * The namespace of the processor. For example, the namespace of mule:set-payload is mule
   */
  private String namespace;

  public ProcessorId(String name, String namespace) {
    this.name = name;
    this.namespace = namespace;
  }

  /**
   * Utility method to extract namespace from full name
   *
   * @param fullName For example mule:logger
   * @return For example mule
   */
  public static String getNamespace(String fullName) {
    String[] split = fullName.split(COLON);
    if (split.length > 1) {
      return split[0];
    }

    return DEFAULT_NAMESPACE;
  }

  /**
   * Utility method to extract name from full name
   *
   * @param fullName For example mule:logger
   * @return For example logger
   */
  public static String getName(String fullName) {
    String[] split = fullName.split(COLON);
    if (split.length > 1) {
      return split[1];
    }
    return split[0];
  }

  public String getFullName() {
    return namespace + COLON + name;
  }

  public String getName() {
    return name;
  }

  public String getNamespace() {
    return namespace;
  }

  @Override
  public boolean equals(Object o) {
    if (o instanceof ProcessorId) {
      ProcessorId processorId = (ProcessorId) o;
      return processorId.getName().equals(name) && processorId.getNamespace().equals(namespace);
    }
    return false;
  }

  @Override
  public int hashCode() {
    return getFullName().hashCode();
  }
}
