/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.util;

import org.mule.runtime.api.meta.MuleVersion;

/**
 * Provides common functionality to handle {@link org.mule.runtime.api.meta.MuleVersion}
 * 
 * @since 2.2.0
 * @author Mulesoft Inc.
 */
public class VersionUtils {

  /**
   * @see VersionUtils#isAtLeastMinMuleVersion(MuleVersion, MuleVersion)
   */
  public static boolean isAtLeastMinMuleVersion(String currentVersion, String minMuleVersion) {
    return isAtLeastMinMuleVersion(new MuleVersion(currentVersion), new MuleVersion(minMuleVersion));
  }

  /**
   * Checks if the current runtime version reaches the minMuleVersion provided. Suffix is ignored.
   * 
   * Runtime Version: 4.1.3, Min Mule Version: 4.1.3 -> true
   * 
   * Runtime Version: 4.1.4, Min Mule Version: 4.1.3 -> true
   * 
   * Runtime Version: 4.1.2, Min Mule Version: 4.1.3 -> false
   * 
   * Runtime Version: 4.1.3-SNAPSHOT, Min Mule Version: 4.1.3 -> true
   * 
   * @param currentVersion Current version of the runtime
   * @param minMuleVersion Minimum version to be able to run
   * @return true if the minMuleVersion is reached by the current runtimeVersion
   */
  public static boolean isAtLeastMinMuleVersion(MuleVersion currentVersion, MuleVersion minMuleVersion) {
    return new MuleVersion(currentVersion.toCompleteNumericVersion()).atLeast(minMuleVersion.toCompleteNumericVersion());
  }

}
