/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.model;

import static org.mule.runtime.api.meta.ExpressionSupport.NOT_SUPPORTED;

import java.util.Objects;

import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.ExclusiveOptionals;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;


/**
 * Exclusive optional pojos for the behaviour to mock.
 *
 * @author Mulesoft Inc.
 */
@ExclusiveOptionals
public class Answer {

  public static final String NAME = "Answer";

  @Parameter
  @Optional
  @Expression(NOT_SUPPORTED)
  private Event thenReturn;

  @Parameter
  @Optional
  @Expression(NOT_SUPPORTED)
  private FlowName thenCall;

  public Event getThenReturn() {
    return thenReturn;
  }

  public FlowName getThenCall() {
    return thenCall;
  }

  public void setThenReturn(Event thenReturn) {
    this.thenReturn = thenReturn;
  }

  public void setThenCall(FlowName thenCall) {
    this.thenCall = thenCall;
  }

  @Override
  public boolean equals(Object object) {
    if (!(object instanceof Answer)) {
      return false;

    } else if (object == this) {
      return true;
    }

    Answer that = (Answer) object;

    return Objects.equals(this.getThenReturn(), that.getThenReturn()) &&
        Objects.equals(this.getThenCall(), that.getThenCall());
  }

  @Override
  public int hashCode() {
    return Objects.hash(getThenReturn(), getThenCall());
  }
}
