/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.model;

import static org.mule.runtime.api.meta.ExpressionSupport.REQUIRED;

import java.util.Objects;

import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Placement;


/**
 * <p>
 * An abstract model that represents the Error of a Mule Event
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class EventError {

  @Parameter
  @Optional
  @Example("ANY")
  @Placement(order = 0)
  private String typeId;

  @Parameter
  @Optional
  @Placement(order = 1)
  @Expression(REQUIRED)
  private Throwable cause;

  @Parameter
  @Optional
  @Example("ANY")
  @Placement(order = 2)
  private String id;

  @Parameter
  @Optional
  @Placement(order = 3)
  @Expression(REQUIRED)
  private Throwable exception;

  public String getTypeId() {
    return id == null ? typeId : id;
  }

  public Object getCause() {
    return exception == null ? cause : exception;
  }

  public void setTypeId(String id) {
    this.id = id;
  }

  public void setCause(Object cause) {
    this.exception = (Throwable) cause;
  }

  @Override
  public boolean equals(Object object) {
    if (!(object instanceof EventError)) {
      return false;

    } else if (object == this) {
      return true;
    }

    EventError that = (EventError) object;

    return Objects.equals(this.getTypeId(), that.getTypeId()) &&
        Objects.equals(this.getCause(), that.getCause());
  }

  @Override
  public int hashCode() {
    return Objects.hash(getTypeId(), getCause());
  }
}
