/*
 * Copyright (c) 2017 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.common.model;

import static org.apache.commons.lang3.Validate.notNull;

import static org.mule.runtime.api.meta.ExpressionSupport.NOT_SUPPORTED;

import java.util.List;

import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;


/**
 * <p>
 * An abstract model that represents a Mule Event
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 2.0.0
 */
public class Event {

  @Optional
  @Expression(NOT_SUPPORTED)
  @Parameter
  private Payload payload = new Payload();

  @Optional
  @Expression(NOT_SUPPORTED)
  @Parameter
  private EventAttributes attributes = new EventAttributes();

  @Optional
  @Expression(NOT_SUPPORTED)
  @Parameter
  private EventError error = new EventError();

  @Optional
  @Expression(NOT_SUPPORTED)
  @Parameter
  private List<Variable> variables;

  @Optional
  @Expression(NOT_SUPPORTED)
  @Parameter
  private List<Property> sessionProperties;

  @Optional
  @Expression(NOT_SUPPORTED)
  @Parameter
  private List<Property> inboundProperties = null;

  @Optional
  @Expression(NOT_SUPPORTED)
  @Parameter
  private List<Property> outboundProperties = null;

  @Optional
  @Expression(NOT_SUPPORTED)
  @Parameter
  private List<Attachment> inboundAttachments = null;

  @Optional
  @Expression(NOT_SUPPORTED)
  @Parameter
  private List<Attachment> outboundAttachments = null;

  public void setVariables(List<Variable> variables) {
    notNull(variables, "Variables can not be null");
    this.variables = variables;
  }

  public Payload getPayload() {
    return payload;
  }

  public EventAttributes getAttributes() {
    return attributes;
  }

  public EventError getError() {
    return error;
  }

  public List<Variable> getVariables() {
    return variables;
  }

  public List<Property> getSessionProperties() {
    return sessionProperties;
  }

  public List<Property> getInboundProperties() {
    return inboundProperties;
  }

  public List<Property> getOutboundProperties() {
    return outboundProperties;
  }

  public List<Attachment> getInboundAttachments() {
    return inboundAttachments;
  }

  public List<Attachment> getOutboundAttachments() {
    return outboundAttachments;
  }

  public void setSessionProperties(List<Property> sessionProperties) {
    notNull(sessionProperties, "Session properties can not be null");
    this.sessionProperties = sessionProperties;
  }

  public void setPayload(Payload payload) {
    this.payload = payload;
  }

  public void setAttributes(EventAttributes attributes) {
    this.attributes = attributes;
  }

  public void setInboundProperties(List<Property> inboundProperties) {
    notNull(inboundProperties, "Inbound properties can not be null");
    this.inboundProperties = inboundProperties;
  }

  public void setOutboundProperties(List<Property> outboundProperties) {
    notNull(outboundProperties, "Outbound properties can not be null");
    this.outboundProperties = outboundProperties;
  }

  public void setInboundAttachments(List<Attachment> inboundAttachments) {
    notNull(inboundAttachments, "Inbound attachments can not be null");
    this.inboundAttachments = inboundAttachments;
  }

  public void setOutboundAttachments(List<Attachment> outboundAttachments) {
    notNull(outboundAttachments, "outbound attachments can not be null");
    this.outboundAttachments = outboundAttachments;
  }

  public void setError(EventError error) {
    this.error = error;
  }
}
